/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.reader;

import java.time.Instant;
import java.util.NoSuchElementException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridOrientation;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.base.Resources;
import org.apache.sis.storage.geotiff.reader.CRSBuilder;
import org.apache.sis.storage.geotiff.reader.GeoKeysLoader;
import org.apache.sis.storage.geotiff.reader.Localization;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public final class GridGeometryBuilder
extends GeoKeysLoader {
    public static final int BIDIMENSIONAL = 2;
    public Vector modelTiePoints;
    private MatrixSIS affine;
    private boolean completeMatrixSpecified;
    private String description;
    private CellGeometry cellGeometry;

    public void setGridToCRS(Vector terms, int size) {
        int length = terms.size();
        this.completeMatrixSpecified = true;
        this.affine = Matrices.createZero((int)size, (int)size);
        this.affine.setElement(size - 1, size - 1, 1.0);
        for (int i = 0; i < length; ++i) {
            this.affine.setElement(i / size, i % size, terms.doubleValue(i));
        }
    }

    public void setScaleFactors(Vector terms) {
        int size = terms.size();
        this.completeMatrixSpecified = false;
        this.affine = Matrices.createZero((int)(size + 1), (int)(size + 1));
        this.affine.setElement(size, size, 1.0);
        for (int i = 0; i < size; ++i) {
            double e = terms.doubleValue(i);
            if (i == 1) {
                e = -e;
            }
            this.affine.setElement(i, i, e);
            this.affine.setElement(i, size, Double.NaN);
        }
    }

    public boolean validateMandatoryTags() {
        MatrixSIS affine = this.affine;
        if (affine == null || this.completeMatrixSpecified) {
            return true;
        }
        Vector modelTiePoints = this.modelTiePoints;
        if (modelTiePoints != null) {
            int nearest = 0;
            double distance = Double.POSITIVE_INFINITY;
            int size = modelTiePoints.size();
            for (int i = 0; i < size; i += 6) {
                double t = modelTiePoints.doubleValue(i);
                double d = t * t;
                t = modelTiePoints.doubleValue(i + 1);
                double d2 = d + t * t;
                t = modelTiePoints.doubleValue(i + 2);
                double d3 = d2 + t * t;
                if (!(d3 < distance)) continue;
                distance = d3;
                nearest = i;
                if (d3 == 0.0) break;
            }
            if (distance != Double.POSITIVE_INFINITY) {
                boolean decimal = true;
                int numDim = affine.getNumRow() - 1;
                int trCol = affine.getNumCol() - 1;
                for (int j = 0; j < numDim; ++j) {
                    double src = -modelTiePoints.doubleValue(nearest + j);
                    double tgt = modelTiePoints.doubleValue(nearest + j + 3);
                    DoubleDouble t = DoubleDouble.of((double)src, (boolean)true).multiply(affine.getNumber(j, j), true).add(tgt, true);
                    affine.setNumber(j, trCol, (Number)t);
                }
                return true;
            }
        }
        return false;
    }

    public GridGeometry build(StoreListeners listeners, long width, long height, Instant imageDate) throws FactoryException {
        GridGeometry gridGeometry;
        double timeCoordinate;
        TemporalCRS temporalCRS;
        int dimension;
        int spatialDimension;
        CoordinateReferenceSystem crs;
        block24: {
            crs = null;
            if (this.keyDirectory != null) {
                CRSBuilder helper = new CRSBuilder(listeners);
                try {
                    crs = helper.build(this);
                    this.description = helper.description;
                    this.cellGeometry = helper.cellGeometry;
                }
                catch (ParameterNotFoundException | NoSuchIdentifierException e) {
                    short key = 23;
                    if (e instanceof NoSuchAuthorityCodeException) {
                        key = 22;
                    }
                    listeners.warning(Resources.forLocale(listeners.getLocale()).getString(key, listeners.getSourceName()), (Exception)e);
                }
                catch (ClassCastException | IllegalArgumentException | NoSuchElementException e) {
                    if (helper.alreadyReported) break block24;
                    GridGeometryBuilder.canNotCreate(listeners, e);
                }
            }
        }
        int n = spatialDimension = crs != null ? crs.getCoordinateSystem().getDimension() : 2;
        if (imageDate != null) {
            dimension = spatialDimension + 1;
            temporalCRS = CommonCRS.defaultTemporal();
            timeCoordinate = DefaultTemporalCRS.castOrCopy((TemporalCRS)temporalCRS).toValue(imageDate);
            if (crs != null) {
                crs = CRS.compound((CoordinateReferenceSystem[])new CoordinateReferenceSystem[]{crs, temporalCRS});
            }
        } else {
            dimension = spatialDimension;
            timeCoordinate = Double.NaN;
            temporalCRS = null;
        }
        DimensionNameType[] axisTypes = new DimensionNameType[dimension];
        long[] high = new long[dimension];
        if (temporalCRS != null) {
            axisTypes[spatialDimension] = DimensionNameType.TIME;
        }
        switch (spatialDimension) {
            default: {
                axisTypes[2] = DimensionNameType.VERTICAL;
            }
            case 2: {
                axisTypes[1] = DimensionNameType.ROW;
                high[1] = height - 1L;
            }
            case 1: {
                axisTypes[0] = DimensionNameType.COLUMN;
                high[0] = width - 1L;
            }
            case 0: 
        }
        GridExtent extent = new GridExtent(axisTypes, null, high, true);
        DefaultMathTransformFactory factory = DefaultMathTransformFactory.provider();
        PixelInCell anchor = this.cellGeometry == CellGeometry.POINT ? PixelInCell.CELL_CENTER : PixelInCell.CELL_CORNER;
        try {
            MathTransform gridToCRS = null;
            if (this.affine != null) {
                Matrix m = Matrices.resizeAffine((Matrix)this.affine, (int)(dimension + 1), (int)(dimension + 1));
                if (temporalCRS != null) {
                    for (int i = 0; i <= dimension; ++i) {
                        m.setElement(spatialDimension, i, 0.0);
                        m.setElement(i, spatialDimension, 0.0);
                    }
                    m.setElement(spatialDimension, dimension, timeCoordinate);
                    m.setElement(spatialDimension, spatialDimension, Double.NaN);
                }
                Matrices.forceNonZeroScales((Matrix)m, (double)Double.NaN);
                gridToCRS = factory.createAffineTransform(m);
            } else if (this.modelTiePoints != null) {
                anchor = PixelInCell.CELL_CENTER;
                gridToCRS = Localization.nonLinear(this.modelTiePoints);
                gridToCRS = factory.createPassThroughTransform(0, gridToCRS, spatialDimension - 2);
                if (temporalCRS != null) {
                    gridToCRS = MathTransforms.compound((MathTransform[])new MathTransform[]{gridToCRS, MathTransforms.linear((double)Double.NaN, (double)timeCoordinate)});
                }
            }
            gridGeometry = new GridGeometry(extent, anchor, gridToCRS, crs);
        }
        catch (TransformException e) {
            GeneralEnvelope envelope = null;
            if (crs != null) {
                envelope = new GeneralEnvelope(crs);
                envelope.setToNaN();
                if (temporalCRS != null && anchor == PixelInCell.CELL_CENTER) {
                    envelope.setRange(spatialDimension, timeCoordinate, Double.NaN);
                }
            }
            gridGeometry = new GridGeometry(extent, (Envelope)envelope, GridOrientation.UNKNOWN);
            GridGeometryBuilder.canNotCreate(listeners, (Exception)((Object)e));
        }
        this.keyDirectory = null;
        this.numericParameters = null;
        this.asciiParameters = null;
        this.modelTiePoints = null;
        this.affine = null;
        return gridGeometry;
    }

    public void completeMetadata(GridGeometry gridGeometry, MetadataBuilder metadata) {
        if (metadata.addSpatialRepresentation(this.description, gridGeometry, true)) {
            PixelOrientation po;
            metadata.setCellGeometry(this.cellGeometry);
            if (this.cellGeometry == CellGeometry.POINT) {
                po = PixelOrientation.CENTER;
            } else if (this.cellGeometry == CellGeometry.AREA) {
                po = PixelOrientation.UPPER_LEFT;
            } else {
                return;
            }
            metadata.setPointInPixel(po);
        }
    }

    private static void canNotCreate(StoreListeners listeners, Exception e) {
        listeners.warning(Resources.forLocale(listeners.getLocale()).getString((short)26, listeners.getSourceName()), e);
    }
}

