/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.Colorizer;
import org.apache.sis.image.ImageLayout;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.MultiSourceImage;
import org.apache.sis.image.MultiSourcePrefetch;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.image.RecoloredImage;
import org.apache.sis.image.StatisticsCalculator;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.image.internal.shared.TilePlaceholder;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.Quantities;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.logging.Logging;

final class ImageOverlay
extends MultiSourceImage {
    private final Shape validArea;
    private final Area[] contributions;
    private final TilePlaceholder emptyTiles;

    static RenderedImage create(RenderedImage[] sources, Rectangle bounds, SampleModel sampleModel, Colorizer colorizer, boolean autoTileSize, boolean parallel) {
        Area aoi = bounds != null ? new Area(bounds) : null;
        Object[] contributions = new Area[sources.length];
        Area validArea = new Area();
        ColorModel colorModel = null;
        int numBands = 0;
        int count = 0;
        for (RenderedImage source : sources = (RenderedImage[])sources.clone()) {
            ColorModel candidate;
            int n = ImageUtilities.getNumBands(source);
            if (n == 0) continue;
            if (n != numBands) {
                if (numBands != 0) {
                    throw new IllegalArgumentException(Resources.format((short)67, numBands, n));
                }
                numBands = n;
            }
            Area area = new Area(ImageUtilities.getValidArea(source));
            if (aoi != null) {
                area.intersect(aoi);
            }
            if (area.isEmpty()) continue;
            Area contrib = new Area(area);
            contrib.subtract(validArea);
            if (contrib.isEmpty()) continue;
            validArea.add(area);
            contributions[count] = contrib;
            sources[count++] = source;
            if (sampleModel == null) {
                sampleModel = source.getSampleModel();
            }
            if (colorModel != null || (candidate = source.getColorModel()) == null || !candidate.isCompatibleSampleModel(sampleModel)) continue;
            colorModel = candidate;
        }
        if (count == 0) {
            throw new IllegalArgumentException(Resources.format((short)80));
        }
        RenderedImage main = sources[0];
        if (colorizer != null) {
            colorModel = colorizer.apply(new Colorizer.Target(sampleModel, main)).orElse(colorModel);
        }
        if (count == 1 && sampleModel.equals(main.getSampleModel())) {
            return colorModel != null ? RecoloredImage.apply(main, colorModel) : main;
        }
        sources = (RenderedImage[])ArraysExt.resize((Object[])sources, (int)count);
        contributions = (Area[])ArraysExt.resize((Object[])contributions, (int)count);
        if (bounds == null) {
            bounds = validArea.getBounds();
        }
        if (autoTileSize) {
            Dimension tileSize = new Dimension(sampleModel.getWidth(), sampleModel.getHeight());
            if (bounds.width % tileSize.width != 0 || bounds.height % tileSize.height != 0) {
                tileSize = ImageLayout.DEFAULT.withPreferredTileSize(tileSize).suggestTileSize(bounds.width, bounds.height);
                sampleModel = sampleModel.createCompatibleSampleModel(tileSize.width, tileSize.height);
            }
        }
        Point minTile = new Point(ImageUtilities.pixelToTileX(main, bounds.x), ImageUtilities.pixelToTileY(main, bounds.y));
        return ImageProcessor.unique(new ImageOverlay(sources, (Area[])contributions, validArea, bounds, minTile, sampleModel, colorModel, parallel));
    }

    private ImageOverlay(RenderedImage[] sources, Area[] contributions, Area validArea, Rectangle bounds, Point minTile, SampleModel sampleModel, ColorModel colorModel, boolean parallel) {
        super(sources, bounds, minTile, sampleModel, colorModel, parallel);
        this.validArea = validArea.isRectangular() ? validArea.getBounds2D() : validArea;
        this.contributions = contributions;
        this.emptyTiles = TilePlaceholder.empty(sampleModel);
    }

    @Override
    public Shape getValidArea() {
        Shape domain = this.validArea;
        if (domain instanceof Area) {
            domain = (Area)((Area)domain).clone();
        } else if (domain instanceof Rectangle2D) {
            domain = (Rectangle2D)((Rectangle2D)domain).clone();
        }
        return domain;
    }

    @Override
    public String[] getPropertyNames() {
        int n = this.getNumSources();
        LinkedHashMap<String, Integer> count = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < n; ++i) {
            String[] names = this.getSource(i).getPropertyNames();
            if (names == null) continue;
            String[] stringArray = names;
            int n2 = stringArray.length;
            block13: for (int j = 0; j < n2; ++j) {
                String name;
                switch (name = stringArray[j]) {
                    case "org.apache.sis.XYDimensions": 
                    case "org.apache.sis.GridGeometry": 
                    case "org.apache.sis.SampleDimensions": 
                    case "org.apache.sis.PositionalAccuracy": {
                        count.put(name, n);
                        continue block13;
                    }
                    case "org.apache.sis.SampleResolutions": 
                    case "org.apache.sis.Statistics": {
                        count.merge(name, 1, Math::addExact);
                    }
                }
            }
        }
        count.values().removeIf(v -> v != n);
        return count.isEmpty() ? null : (String[])count.keySet().toArray(String[]::new);
    }

    @Override
    public Object getProperty(String key) {
        switch (key) {
            case "org.apache.sis.XYDimensions": 
            case "org.apache.sis.GridGeometry": 
            case "org.apache.sis.SampleDimensions": {
                return this.getConstantProperty(key);
            }
            case "org.apache.sis.PositionalAccuracy": {
                return this.getCombinedProperty(key, Quantity[].class, q -> (Quantity[])q.clone(), ImageOverlay::combine, false);
            }
            case "org.apache.sis.SampleResolutions": {
                return this.getCombinedProperty(key, double[].class, rec$ -> (double[])((double[])rec$).clone(), ImageOverlay::combine, true);
            }
            case "org.apache.sis.Statistics": {
                return this.getCombinedProperty(key, Statistics[].class, StatisticsCalculator::clone, ImageOverlay::combine, true);
            }
        }
        return Image.UndefinedProperty;
    }

    private Object getConstantProperty(String key) {
        Object result = Image.UndefinedProperty;
        int n = this.getNumSources();
        for (int i = 0; i < n; ++i) {
            Object c = this.getSource(i).getProperty(key);
            if (c == Image.UndefinedProperty) continue;
            if (result == Image.UndefinedProperty) {
                result = c;
                continue;
            }
            if (Objects.deepEquals(result, c)) continue;
            return Image.UndefinedProperty;
        }
        return result;
    }

    private <V> Object getCombinedProperty(String key, Class<V> type, Function<V, V> cloner, BiConsumer<V, V> combiner, boolean required) {
        Object result = null;
        int n = this.getNumSources();
        for (int i = 0; i < n; ++i) {
            Object value = this.getSource(i).getProperty(key);
            if (type.isInstance(value)) {
                Object c = value;
                if (result == null) {
                    result = cloner.apply(c);
                    continue;
                }
                try {
                    combiner.accept(result, c);
                    continue;
                }
                catch (UnconvertibleException e) {
                    Logging.recoverableException((Logger)ImageUtilities.LOGGER, ImageOverlay.class, (String)"getProperty", (Throwable)e);
                    return Image.UndefinedProperty;
                }
            }
            if (!required) continue;
            return Image.UndefinedProperty;
        }
        return result != null ? result : Image.UndefinedProperty;
    }

    private static void combine(Statistics[] result, Statistics[] more) {
        int i = Math.min(result.length, more.length);
        while (--i >= 0) {
            result[i].combine(more[i]);
        }
    }

    private static void combine(double[] result, double[] more) {
        int i = Math.min(result.length, more.length);
        while (--i >= 0) {
            double value = more[i];
            double previous = result[i];
            if (!(value < previous) && !Double.isNaN(previous)) continue;
            result[i] = value;
        }
    }

    private static void combine(Quantity[] result, Quantity[] more) {
        int i = Math.min(result.length, more.length);
        while (--i >= 0) {
            result[i] = Quantities.max((Quantity)result[i], (Quantity)more[i]);
        }
    }

    @Override
    protected Raster computeTile(int tileX, int tileY, WritableRaster target) {
        int n;
        Rectangle aoi = new Rectangle(ImageUtilities.tileToPixelX(this, tileX), ImageUtilities.tileToPixelY(this, tileY), this.getTileWidth(), this.getTileHeight());
        Raster shared = null;
        int i = n = this.getNumSources();
        while (--i >= 0) {
            if (!this.contributions[i].intersects(aoi)) continue;
            RenderedImage source = this.getSource(i);
            Rectangle bounds = this.getBounds();
            ImageUtilities.clipBounds(source, bounds);
            if (bounds.isEmpty()) continue;
            if (target == null) {
                int ty;
                int dy;
                int tx;
                int dx;
                if (shared == null && (dx = (tx = ImageUtilities.pixelToTileX(source, aoi.x)) - source.getMinTileX()) >= 0 && dx < source.getNumXTiles() && (dy = (ty = ImageUtilities.pixelToTileY(source, aoi.y)) - source.getMinTileY()) >= 0 && dy < source.getNumYTiles()) {
                    shared = source.getTile(tx, ty);
                    if (shared.getMinX() == aoi.x && shared.getMinY() == aoi.y && this.sampleModel.equals(shared.getSampleModel())) continue;
                    shared = null;
                }
                target = WritableRaster.createWritableRaster(this.sampleModel, aoi.getLocation());
                if (shared != null) {
                    target.setRect(shared);
                    shared = null;
                }
            }
            ImageOverlay.copyData(bounds, source, target);
        }
        return target != null ? target : (shared != null ? shared : this.emptyTiles.create(aoi.getLocation()));
    }

    @Override
    protected Disposable prefetch(Rectangle tiles) {
        Rectangle aoi = ImageUtilities.tilesToPixels(this, tiles);
        int n = this.getNumSources();
        Object[] sources = new RenderedImage[n];
        int count = 0;
        for (int i = 0; i < n; ++i) {
            RenderedImage source = this.getSource(i);
            if (!(source instanceof PlanarImage) || !this.contributions[i].intersects(aoi)) continue;
            sources[count++] = source;
        }
        return new MultiSourcePrefetch((RenderedImage[])ArraysExt.resize((Object[])sources, (int)count), aoi).run(this.parallel);
    }
}

