/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client.http;

import com.fasterxml.jackson.databind.JavaType;
import com.netflix.config.DynamicPropertyFactory;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessorManager;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.HttpStatus;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClientFilter
implements HttpClientFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpClientFilter.class);
    private static final boolean enabled = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.http.filter.client.default.enabled", true).get();
    private static final String PRINT_ERROR_RESPONSE = "servicecomb.http.filter.client.default.shouldPrintErrorResponse";

    public int getOrder() {
        return 10000;
    }

    public CompletableFuture<Void> beforeSendRequestAsync(Invocation invocation, HttpServletRequestEx requestEx) {
        return CompletableFuture.completedFuture(null);
    }

    public boolean enabled() {
        return enabled;
    }

    protected ProduceProcessor findProduceProcessor(RestOperationMeta restOperation, HttpServletResponseEx responseEx) {
        String contentType = responseEx.getHeader("Content-Type");
        if (contentType == null) {
            return null;
        }
        String contentTypeForFind = contentType;
        int idx = contentType.indexOf(59);
        if (idx != -1) {
            contentTypeForFind = contentType.substring(0, idx);
        }
        return restOperation.findProduceProcessor(contentTypeForFind);
    }

    protected Response extractResponse(Invocation invocation, HttpServletResponseEx responseEx) {
        Object result = invocation.getHandlerContext().get("servicecomb-readStreamPart");
        if (result != null) {
            return Response.create((Response.StatusType)responseEx.getStatusType(), result);
        }
        OperationMeta operationMeta = invocation.getOperationMeta();
        JavaType responseType = invocation.findResponseType(responseEx.getStatus());
        RestOperationMeta swaggerRestOperation = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        ProduceProcessor produceProcessor = this.findProduceProcessor(swaggerRestOperation, responseEx);
        if (produceProcessor == null) {
            LOGGER.warn("Response content-type {} is not supported. Method {}, path {}, statusCode {}, reasonPhrase {}.", new Object[]{responseEx.getHeader("Content-Type"), swaggerRestOperation.getHttpMethod(), swaggerRestOperation.getAbsolutePath(), responseEx.getStatus(), responseEx.getStatusType().getReasonPhrase()});
            produceProcessor = ProduceProcessorManager.INSTANCE.findDefaultProcessor();
        }
        try {
            result = produceProcessor.decodeResponse(responseEx.getBodyBuffer(), responseType);
            Response response = Response.create((Response.StatusType)responseEx.getStatusType(), result);
            if (response.isFailed()) {
                LOGGER.warn("invoke operation [{}] failed, status={}, msg={}", new Object[]{invocation.getMicroserviceQualifiedName(), responseEx.getStatusType().getStatusCode(), result == null ? "" : result.toString()});
            }
            return response;
        }
        catch (Exception e) {
            if (DynamicPropertyFactory.getInstance().getBooleanProperty(PRINT_ERROR_RESPONSE, false).get()) {
                LOGGER.error("failed to decode response body. response is {}", (Object)responseEx.getBodyBuffer());
            } else {
                LOGGER.error("failed to decode response body.", (Throwable)e);
            }
            String msg = String.format("Failed to decode response body. Operation %s.", invocation.getMicroserviceQualifiedName());
            if (HttpStatus.isSuccess((int)responseEx.getStatus())) {
                return Response.createConsumerFail((Throwable)new InvocationException(400, responseEx.getStatusType().getReasonPhrase(), (Object)new CommonExceptionData(msg), (Throwable)e));
            }
            return Response.createConsumerFail((Throwable)new InvocationException(responseEx.getStatus(), responseEx.getStatusType().getReasonPhrase(), (Object)new CommonExceptionData(msg), (Throwable)e));
        }
    }

    public Response afterReceiveResponse(Invocation invocation, HttpServletResponseEx responseEx) {
        Response response = this.extractResponse(invocation, responseEx);
        for (String headerName : responseEx.getHeaderNames()) {
            if (headerName.equals(":status")) continue;
            Collection headerValues = responseEx.getHeaders(headerName);
            for (String headerValue : headerValues) {
                response.addHeader(headerName, headerValue);
            }
        }
        return response;
    }
}

