/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.any;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.OutputEx;
import io.protostuff.SchemaEx;
import io.protostuff.SchemaWriter;
import io.protostuff.WireFormat;
import io.protostuff.compiler.model.Message;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.protobuf.ProtoMapper;
import org.apache.servicecomb.foundation.protobuf.RootDeserializer;
import org.apache.servicecomb.foundation.protobuf.RootSerializer;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoConst;
import org.apache.servicecomb.foundation.protobuf.internal.schema.any.AnyEntry;

public class AnyEntrySchema
implements SchemaEx<Object> {
    private final ProtoMapper protoMapper;
    private final Map<String, SchemaWriter<Object>> anyEntrySserializers = new ConcurrentHashMapEx();
    private final Map<String, RootDeserializer<Object>> rootDeserializers = new ConcurrentHashMapEx();
    private final int keyTag = WireFormat.makeTag((int)1, (int)2);
    private final int valueTag = WireFormat.makeTag((int)2, (int)2);

    public AnyEntrySchema(ProtoMapper protoMapper) {
        this.protoMapper = protoMapper;
    }

    @Override
    public void init() {
    }

    @Override
    public void mergeFrom(InputEx input, Object message) throws IOException {
        input.readFieldNumber();
        String typeUrl = input.readString();
        input.readFieldNumber();
        byte[] bytes = input.readByteArray();
        input.readFieldNumber();
        AnyEntry anyEntry = (AnyEntry)message;
        anyEntry.setTypeUrl(typeUrl);
        anyEntry.setValue(bytes);
    }

    public Object deseriaze(InputEx input) throws IOException {
        AnyEntry anyEntry = new AnyEntry();
        input.mergeObject(anyEntry, this);
        if (anyEntry.getTypeUrl().startsWith(ProtoConst.PACK_SCHEMA)) {
            return this.standardUnpack(anyEntry.getTypeUrl(), anyEntry.getValue());
        }
        return this.jsonExtendMergeFrom(anyEntry.getTypeUrl(), anyEntry.getValue());
    }

    protected Object standardUnpack(String typeUrl, byte[] bytes) throws IOException {
        String msgCanonicalName = typeUrl.substring(ProtoConst.PACK_SCHEMA.length());
        RootDeserializer valueDeserializer = this.rootDeserializers.computeIfAbsent(msgCanonicalName, this::createRootDeserializerFromCanonicaName);
        Object value = valueDeserializer.deserialize(bytes);
        if (value instanceof Map) {
            ((Map)value).put(ProtoConst.JSON_ID_NAME, valueDeserializer.getSchema().messageName());
        }
        return value;
    }

    protected RootDeserializer<Object> createRootDeserializerFromCanonicaName(String msgCanonicalName) {
        Message message = this.protoMapper.getMessageFromCanonicaName(msgCanonicalName);
        if (message == null) {
            throw new IllegalStateException("can not find proto message to create deserializer, name=" + msgCanonicalName);
        }
        JavaType javaType = this.protoMapper.getAnyTypes().getOrDefault(msgCanonicalName, ProtoConst.MAP_TYPE);
        return this.protoMapper.createRootDeserializer(message, (Type)javaType);
    }

    protected Object jsonExtendMergeFrom(String typeUrl, byte[] bytes) throws IOException {
        return this.protoMapper.getJsonMapper().readValue(bytes, Object.class);
    }

    protected String getInputActualTypeName(Object input) {
        if (!(input instanceof Map)) {
            return input.getClass().getSimpleName();
        }
        Object actualTypeName = ((Map)input).get(ProtoConst.JSON_ID_NAME);
        if (actualTypeName instanceof String) {
            return (String)actualTypeName;
        }
        return null;
    }

    @Override
    public void writeTo(OutputEx output, Object value) throws IOException {
        String actualTypeName = this.getInputActualTypeName(value);
        SchemaWriter entryWriter = actualTypeName == null ? this::jsonExtend : this.anyEntrySserializers.computeIfAbsent(actualTypeName, n -> this.createEntryWriter((String)n, value));
        entryWriter.writeTo(output, (Object)value);
    }

    private SchemaWriter<Object> createEntryWriter(String actualTypeName, Object _value) {
        Message message = this.protoMapper.getProto().getMessage(actualTypeName);
        if (message == null) {
            return this::jsonExtend;
        }
        RootSerializer valueSerializer = this.protoMapper.createRootSerializer(message, _value.getClass());
        String valueCanonicalName = message.getCanonicalName();
        return (output, value) -> this.standardPack(output, value, valueCanonicalName, valueSerializer);
    }

    protected void standardPack(OutputEx output, Object message, String canonicalName, RootSerializer valueSerializer) throws IOException {
        output.writeString(this.keyTag, 1, ProtoConst.PACK_SCHEMA + canonicalName);
        byte[] bytes = valueSerializer.serialize(message);
        output.writeByteArray(this.valueTag, 1, bytes);
    }

    protected void jsonExtend(OutputEx output, Object input) throws IOException {
        output.writeString(this.keyTag, 1, ProtoConst.JSON_SCHEMA + input.getClass().getName());
        byte[] bytes = this.protoMapper.getJsonMapper().writeValueAsBytes(input);
        output.writeByteArray(this.valueTag, 1, bytes);
    }
}

