/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.template;

import com.google.common.collect.Maps;
import com.netflix.ribbon.template.MatrixVar;
import com.netflix.ribbon.template.ParsedTemplate;
import com.netflix.ribbon.template.PathVar;
import com.netflix.ribbon.template.TemplateParsingException;
import com.netflix.ribbon.template.TemplateVar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TemplateParser {
    public static List<Object> parseTemplate(String template) {
        String key;
        ArrayList<Object> templateParts = new ArrayList<Object>();
        if (template == null) {
            return templateParts;
        }
        StringBuilder val = new StringBuilder();
        block4: for (char c : template.toCharArray()) {
            switch (c) {
                case '{': {
                    key = val.toString();
                    val = new StringBuilder();
                    templateParts.add(key);
                    continue block4;
                }
                case '}': {
                    key = val.toString();
                    val = new StringBuilder();
                    if (key.charAt(0) == ';') {
                        templateParts.add(new MatrixVar(key.substring(1)));
                        continue block4;
                    }
                    templateParts.add(new PathVar(key));
                    continue block4;
                }
                default: {
                    val.append(c);
                }
            }
        }
        key = val.toString();
        if (!key.isEmpty()) {
            templateParts.add(key);
        }
        return templateParts;
    }

    public static String toData(Map<String, Object> variables, ParsedTemplate parsedTemplate) throws TemplateParsingException {
        return TemplateParser.toData(variables, parsedTemplate.getTemplate(), parsedTemplate.getParsed());
    }

    public static String toData(Map<String, Object> variables, String template, List<Object> parsedList) throws TemplateParsingException {
        int params = variables.size();
        if (variables.isEmpty() && template.indexOf(123) == 0) {
            return template;
        }
        StringBuilder builder = new StringBuilder();
        for (Object part : parsedList) {
            if (part instanceof TemplateVar) {
                Object var = variables.get(part.toString());
                if (part instanceof MatrixVar) {
                    if (var == null) continue;
                    builder.append(';').append(part.toString()).append('=').append(var);
                    --params;
                    continue;
                }
                if (part instanceof PathVar) {
                    if (var == null) {
                        throw new TemplateParsingException(String.format("template variable %s was not supplied for template %s", part.toString(), template));
                    }
                    builder.append(var);
                    --params;
                    continue;
                }
                throw new TemplateParsingException(String.format("template variable type %s is not supplied for template template %s", part.getClass().getCanonicalName(), template));
            }
            builder.append(part.toString());
        }
        return builder.toString();
    }

    public static void main(String[] args) throws TemplateParsingException {
        String template = "/abc/{id}?name={name}";
        HashMap vars = Maps.newHashMap();
        vars.put("id", "5");
        vars.put("name", "netflix");
        List<Object> list = TemplateParser.parseTemplate(template);
        System.out.println(TemplateParser.toData(vars, template, list));
    }
}

