/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.bootstrap.Bootstrap;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientOperator;
import reactor.netty.tcp.ProxyProvider;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpClient;

final class HttpClientOnConnectMap
extends HttpClientOperator {
    final BiFunction<? super Mono<? extends Connection>, ? super Bootstrap, ? extends Mono<? extends Connection>> connector;

    HttpClientOnConnectMap(HttpClient client, BiFunction<? super Mono<? extends Connection>, ? super Bootstrap, ? extends Mono<? extends Connection>> connector) {
        super(client);
        this.connector = Objects.requireNonNull(connector, "mapConnect");
    }

    @Override
    protected TcpClient tcpConfiguration() {
        return new OnConnectMapTcpClient(this.source.tcpConfiguration(), this.connector);
    }

    static final class OnConnectMapTcpClient
    extends TcpClient {
        final TcpClient sourceTcp;
        final BiFunction<? super Mono<? extends Connection>, ? super Bootstrap, ? extends Mono<? extends Connection>> connector;

        OnConnectMapTcpClient(TcpClient sourceTcp, BiFunction<? super Mono<? extends Connection>, ? super Bootstrap, ? extends Mono<? extends Connection>> connector) {
            this.connector = connector;
            this.sourceTcp = sourceTcp;
        }

        @Override
        public Bootstrap configure() {
            return this.sourceTcp.configure();
        }

        @Override
        public Mono<? extends Connection> connect(Bootstrap b) {
            return this.connector.apply((Mono<? extends Connection>)this.sourceTcp.connect(b), (Bootstrap)b);
        }

        @Override
        @Nullable
        public ProxyProvider proxyProvider() {
            return this.sourceTcp.proxyProvider();
        }

        @Override
        @Nullable
        public SslProvider sslProvider() {
            return this.sourceTcp.sslProvider();
        }
    }
}

