/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.parser.FileReader;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathFileReader
implements FileReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathFileReader.class);

    public static InputStream readResource(String name) {
        String classpath = System.getProperty("java.class.path");
        LOGGER.trace("Reading {} from classpath={}", (Object)name, (Object)classpath);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("Can not obtain classloader instance from current thread");
        }
        return classLoader.getResourceAsStream(name);
    }

    @Override
    @Nullable
    public CharStream read(String name) {
        try {
            InputStream resource = ClasspathFileReader.readResource(name);
            if (resource != null) {
                return CharStreams.fromStream((InputStream)resource);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not read {}", (Object)name, (Object)e);
        }
        return null;
    }
}

