/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.SpectatorContext;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.SpectatorMonitor;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.util.Preconditions;
import java.lang.ref.WeakReference;

public class NumberGauge
extends AbstractMonitor<Number>
implements Gauge<Number>,
SpectatorMonitor {
    private final MonitorConfig baseConfig;
    private WeakReference<Number> numberRef;

    protected NumberGauge(MonitorConfig config) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.baseConfig = config;
    }

    public NumberGauge(MonitorConfig config, Number number) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.baseConfig = config;
        Preconditions.checkNotNull(number, "number");
        this.numberRef = new WeakReference<Number>(number);
    }

    @Override
    public Number getValue(int pollerIdx) {
        Number n = (Number)this.numberRef.get();
        return n != null ? (Number)n : (Number)Double.NaN;
    }

    @Override
    public void initializeSpectator(TagList tags) {
        Number n = (Number)this.numberRef.get();
        if (n != null) {
            SpectatorContext.polledGauge(this.baseConfig.withAdditionalTags(tags)).monitorValue(n);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberGauge)) {
            return false;
        }
        NumberGauge that = (NumberGauge)o;
        return this.config.equals(that.config) && ((Number)this.getValue()).equals(that.getValue());
    }

    public int hashCode() {
        int result = this.getConfig().hashCode();
        result = 31 * result + this.getValue(0).hashCode();
        return result;
    }

    public String toString() {
        return "NumberGauge{config=" + this.config + ", number=" + this.numberRef.get() + '}';
    }

    protected Number getBackingNumber() {
        return (Number)this.numberRef.get();
    }

    protected void setBackingNumber(Number number) {
        this.numberRef = new WeakReference<Number>(number);
    }
}

