/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.spring.cloud.zuul.tracing;

import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.servlet.TracingFilter;
import com.netflix.zuul.context.RequestContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicecomb.spring.cloud.zuul.tracing.TracePostZuulFilter;
import org.apache.servicecomb.spring.cloud.zuul.tracing.TracePreZuulFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"servicecomb.tracing.enabled"}, havingValue="true", matchIfMissing=true)
public class SpringTracingConfiguration {
    @Bean
    FilterRegistrationBean traceWebFilter(HttpTracing httpTracing) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean(TracingFilter.create((HttpTracing)httpTracing), new ServletRegistrationBean[0]);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
        filterRegistrationBean.setOrder(Integer.MIN_VALUE);
        return filterRegistrationBean;
    }

    @Bean
    HttpClientHandler<RequestContext, HttpServletResponse> httpClientHandler(HttpTracing httpTracing) {
        return HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new ZuulHttpClientAdapter());
    }

    @Bean
    TracePreZuulFilter tracePreZuulFilter(HttpTracing tracing, HttpClientHandler<RequestContext, HttpServletResponse> handler) {
        return new TracePreZuulFilter(tracing, handler);
    }

    @Bean
    TracePostZuulFilter tracePostZuulFilter(HttpTracing tracing, HttpClientHandler<RequestContext, HttpServletResponse> handler) {
        return new TracePostZuulFilter(tracing, handler);
    }

    private static class ZuulHttpClientAdapter
    extends HttpClientAdapter<RequestContext, HttpServletResponse> {
        private ZuulHttpClientAdapter() {
        }

        @Nullable
        public String method(@Nonnull RequestContext request) {
            return request.getRequest().getMethod();
        }

        @Nullable
        public String url(@Nonnull RequestContext request) {
            return request.getRequest().getRequestURI();
        }

        @Nullable
        public String requestHeader(@Nonnull RequestContext request, @Nonnull String name) {
            return request.getRequest().getHeader(name);
        }

        @Nullable
        public Integer statusCode(@Nonnull HttpServletResponse response) {
            return response.getStatus() == 0 ? 500 : response.getStatus();
        }
    }
}

