/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.weblogger.webservices.adminprotocol.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.roller.weblogger.webservices.adminprotocol.sdk.Entry;
import org.apache.roller.weblogger.webservices.adminprotocol.sdk.LocaleString;
import org.apache.roller.weblogger.webservices.adminprotocol.sdk.Service;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;

public class UserEntry
extends Entry {
    private String name;
    private String screenName;
    private String fullName;
    private String password;
    private Locale locale;
    private TimeZone timezone;
    private Date dateCreated;
    private String emailAddress;
    private Boolean enabled;

    public UserEntry(String name, String urlPrefix) {
        this.setName(name);
        String href = urlPrefix + "/" + "users" + "/" + name;
        this.setHref(href);
    }

    public UserEntry(Element e, String urlPrefix) {
        this.populate(e, urlPrefix);
    }

    public UserEntry(InputStream stream, String urlPrefix) throws JDOMException, IOException {
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build(stream);
        Element e = d.detachRootElement();
        this.populate(e, urlPrefix);
    }

    private void populate(Element e, String urlPrefix) {
        Element enabledElement;
        Element createdElement;
        Element emailElement;
        Element tzElement;
        Element localeElement;
        Element passwordElement;
        Element nameElement = e.getChild("name", NAMESPACE);
        if (nameElement != null) {
            this.setName(nameElement.getText());
        }
        String href = urlPrefix + "/" + "users" + "/" + this.getName();
        this.setHref(href);
        Element fullNameElement = e.getChild("full-name", NAMESPACE);
        if (fullNameElement != null) {
            this.setFullName(fullNameElement.getText());
        }
        if ((passwordElement = e.getChild("password", NAMESPACE)) != null) {
            this.setPassword(passwordElement.getText());
        }
        if ((localeElement = e.getChild("locale", Service.NAMESPACE)) != null) {
            this.setLocale(localeElement.getText());
        }
        if ((tzElement = e.getChild("timezone", Service.NAMESPACE)) != null) {
            this.setTimezone(tzElement.getText());
        }
        if ((emailElement = e.getChild("email-address", Service.NAMESPACE)) != null) {
            this.setEmailAddress(emailElement.getText());
        }
        if ((createdElement = e.getChild("date-created", Service.NAMESPACE)) != null) {
            this.setDateCreated(new Date(Long.valueOf(createdElement.getText())));
        }
        if ((enabledElement = e.getChild("enabled", Service.NAMESPACE)) != null) {
            this.setEnabled(Boolean.valueOf(enabledElement.getText()));
        }
    }

    public String getType() {
        return "user";
    }

    public Document toDocument() {
        Boolean enabled;
        String emailAddress;
        TimeZone timezone;
        Locale locale;
        String password;
        String fullName;
        String screenName;
        String name;
        Element userElement = new Element("user", NAMESPACE);
        Document doc = new Document(userElement);
        String href = this.getHref();
        if (href != null) {
            userElement.setAttribute("href", href);
        }
        if ((name = this.getName()) != null) {
            Element nameElement = new Element("name", Service.NAMESPACE);
            Text nameText = new Text(name);
            nameElement.addContent((Content)nameText);
            userElement.addContent((Content)nameElement);
        }
        if ((screenName = this.getScreenName()) != null) {
            Element screenNameElement = new Element("screen-name", NAMESPACE);
            Text screenNameText = new Text(screenName);
            screenNameElement.addContent((Content)screenNameText);
            userElement.addContent((Content)screenNameElement);
        }
        if ((fullName = this.getFullName()) != null) {
            Element fullNameElement = new Element("full-name", NAMESPACE);
            Text fullNameText = new Text(fullName);
            fullNameElement.addContent((Content)fullNameText);
            userElement.addContent((Content)fullNameElement);
        }
        if ((password = this.getPassword()) != null) {
            Element passwordElement = new Element("password", NAMESPACE);
            Text passwordText = new Text(password);
            passwordElement.addContent((Content)passwordText);
            userElement.addContent((Content)passwordElement);
        }
        if ((locale = this.getLocale()) != null) {
            Element localeElement = new Element("locale", Service.NAMESPACE);
            Text localeText = new Text(this.getLocale().toString());
            localeElement.addContent((Content)localeText);
            userElement.addContent((Content)localeElement);
        }
        if ((timezone = this.getTimezone()) != null) {
            Element timezoneElement = new Element("timezone", Service.NAMESPACE);
            Text timezoneText = new Text(timezone.getID());
            timezoneElement.addContent((Content)timezoneText);
            userElement.addContent((Content)timezoneElement);
        }
        if ((emailAddress = this.getEmailAddress()) != null) {
            Element emailAddressElement = new Element("email-address", Service.NAMESPACE);
            Text emailAddressText = new Text(emailAddress);
            emailAddressElement.addContent((Content)emailAddressText);
            userElement.addContent((Content)emailAddressElement);
        }
        Date datedCreated = this.getDateCreated();
        if (this.dateCreated != null) {
            Element dateCreatedElement = new Element("date-created", Service.NAMESPACE);
            Text dateCreatedText = new Text(String.valueOf(this.dateCreated.getTime()));
            dateCreatedElement.addContent((Content)dateCreatedText);
            userElement.addContent((Content)dateCreatedElement);
        }
        if ((enabled = this.getEnabled()) != null) {
            Element enabledElement = new Element("enabled", NAMESPACE);
            Text enabledText = new Text(enabled.toString());
            enabledElement.addContent((Content)enabledText);
            userElement.addContent((Content)enabledElement);
        }
        return doc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLocale(String localeString) {
        this.locale = new LocaleString(localeString).getLocale();
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public void setTimezone(String timezoneString) {
        this.timezone = TimeZone.getTimeZone(timezoneString);
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        UserEntry other = (UserEntry)o;
        if (!UserEntry.areEqual(this.getEmailAddress(), other.getEmailAddress())) {
            return false;
        }
        if (!UserEntry.areEqual(this.getFullName(), other.getFullName())) {
            return false;
        }
        if (!UserEntry.areEqual(this.getLocale(), other.getLocale())) {
            return false;
        }
        if (!UserEntry.areEqual(this.getName(), other.getName())) {
            return false;
        }
        if (!UserEntry.areEqual(this.getTimezone(), other.getTimezone())) {
            return false;
        }
        if (!UserEntry.areEqual(this.getEnabled(), other.getEnabled())) {
            return false;
        }
        return super.equals(o);
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    static interface Tags {
        public static final String USER = "user";
        public static final String NAME = "name";
        public static final String SCREEN_NAME = "screen-name";
        public static final String FULL_NAME = "full-name";
        public static final String PASSWORD = "password";
        public static final String EMAIL_ADDRESS = "email-address";
        public static final String LOCALE = "locale";
        public static final String TIMEZONE = "timezone";
        public static final String DATE_CREATED = "date-created";
        public static final String ENABLED = "enabled";
    }
}

