/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse;
import apache.rocketmq.v2.HeartbeatRequest;
import apache.rocketmq.v2.QueryAssignmentRequest;
import apache.rocketmq.v2.QueryAssignmentResponse;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.Status;
import apache.rocketmq.v2.TelemetryCommand;
import apache.rocketmq.v2.VerifyMessageCommand;
import apache.rocketmq.v2.VerifyMessageResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Metadata;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.apis.consumer.PushConsumer;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.java.exception.BadRequestException;
import org.apache.rocketmq.client.java.exception.ForbiddenException;
import org.apache.rocketmq.client.java.exception.InternalErrorException;
import org.apache.rocketmq.client.java.exception.NotFoundException;
import org.apache.rocketmq.client.java.exception.ProxyTimeoutException;
import org.apache.rocketmq.client.java.exception.TooManyRequestsException;
import org.apache.rocketmq.client.java.exception.UnsupportedException;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.impl.ClientSettings;
import org.apache.rocketmq.client.java.impl.consumer.Assignment;
import org.apache.rocketmq.client.java.impl.consumer.Assignments;
import org.apache.rocketmq.client.java.impl.consumer.ConsumeService;
import org.apache.rocketmq.client.java.impl.consumer.ConsumerImpl;
import org.apache.rocketmq.client.java.impl.consumer.FifoConsumeService;
import org.apache.rocketmq.client.java.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.java.impl.consumer.ProcessQueueImpl;
import org.apache.rocketmq.client.java.impl.consumer.PushConsumerSettings;
import org.apache.rocketmq.client.java.impl.consumer.StandardConsumeService;
import org.apache.rocketmq.client.java.message.MessageCommon;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.metrics.MessageCacheObserver;
import org.apache.rocketmq.client.java.misc.ExecutorServices;
import org.apache.rocketmq.client.java.misc.ThreadFactoryImpl;
import org.apache.rocketmq.client.java.retry.RetryPolicy;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.route.TopicRouteData;
import org.apache.rocketmq.client.java.rpc.RpcInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PushConsumerImpl
extends ConsumerImpl
implements PushConsumer,
MessageCacheObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushConsumerImpl.class);
    final AtomicLong consumptionOkQuantity;
    final AtomicLong consumptionErrorQuantity;
    private final ClientConfiguration clientConfiguration;
    private final PushConsumerSettings pushConsumerSettings;
    private final String consumerGroup;
    private final Map<String, FilterExpression> subscriptionExpressions;
    private final ConcurrentMap<String, Assignments> cacheAssignments;
    private final MessageListener messageListener;
    private final int maxCacheMessageCount;
    private final int maxCacheMessageSizeInBytes;
    private final AtomicLong receptionTimes;
    private final AtomicLong receivedMessagesQuantity;
    private final ThreadPoolExecutor consumptionExecutor;
    private final ConcurrentMap<MessageQueueImpl, ProcessQueue> processQueueTable;
    private ConsumeService consumeService;
    private volatile ScheduledFuture<?> scanAssignmentsFuture;

    public PushConsumerImpl(ClientConfiguration clientConfiguration, String consumerGroup, Map<String, FilterExpression> subscriptionExpressions, MessageListener messageListener, int maxCacheMessageCount, int maxCacheMessageSizeInBytes, int consumptionThreadCount) {
        super(clientConfiguration, consumerGroup, subscriptionExpressions.keySet());
        this.clientConfiguration = clientConfiguration;
        org.apache.rocketmq.client.java.message.protocol.Resource groupResource = new org.apache.rocketmq.client.java.message.protocol.Resource(consumerGroup);
        this.pushConsumerSettings = new PushConsumerSettings(this.clientId, this.endpoints, groupResource, clientConfiguration.getRequestTimeout(), subscriptionExpressions);
        this.consumerGroup = consumerGroup;
        this.subscriptionExpressions = subscriptionExpressions;
        this.cacheAssignments = new ConcurrentHashMap<String, Assignments>();
        this.messageListener = messageListener;
        this.maxCacheMessageCount = maxCacheMessageCount;
        this.maxCacheMessageSizeInBytes = maxCacheMessageSizeInBytes;
        this.receptionTimes = new AtomicLong(0L);
        this.receivedMessagesQuantity = new AtomicLong(0L);
        this.consumptionOkQuantity = new AtomicLong(0L);
        this.consumptionErrorQuantity = new AtomicLong(0L);
        this.processQueueTable = new ConcurrentHashMap<MessageQueueImpl, ProcessQueue>();
        this.consumptionExecutor = new ThreadPoolExecutor(consumptionThreadCount, consumptionThreadCount, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl("MessageConsumption"));
    }

    @Override
    protected void startUp() throws Exception {
        try {
            LOGGER.info("Begin to start the rocketmq push consumer, clientId={}", (Object)this.clientId);
            super.startUp();
            this.clientMeterProvider.setMessageCacheObserver(this);
            ScheduledExecutorService scheduler = this.clientManager.getScheduler();
            this.consumeService = this.createConsumeService();
            this.consumeService.startAsync().awaitRunning();
            this.scanAssignmentsFuture = scheduler.scheduleWithFixedDelay(() -> {
                try {
                    this.scanAssignments();
                }
                catch (Throwable t) {
                    LOGGER.error("Exception raised while scanning the load assignments, clientId={}", (Object)this.clientId, (Object)t);
                }
            }, 1L, 5L, TimeUnit.SECONDS);
            LOGGER.info("The rocketmq push consumer starts successfully, clientId={}", (Object)this.clientId);
        }
        catch (Throwable t) {
            LOGGER.error("Exception raised while starting the rocketmq push consumer, clientId={}", (Object)this.clientId, (Object)t);
            this.shutDown();
            throw t;
        }
    }

    @Override
    protected void shutDown() throws InterruptedException {
        LOGGER.info("Begin to shutdown the rocketmq push consumer, clientId={}", (Object)this.clientId);
        if (null != this.scanAssignmentsFuture) {
            this.scanAssignmentsFuture.cancel(false);
        }
        super.shutDown();
        this.consumeService.stopAsync().awaitTerminated();
        this.consumptionExecutor.shutdown();
        ExecutorServices.awaitTerminated(this.consumptionExecutor);
        LOGGER.info("Shutdown the rocketmq push consumer successfully, clientId={}", (Object)this.clientId);
    }

    private ConsumeService createConsumeService() {
        ScheduledExecutorService scheduler = this.clientManager.getScheduler();
        if (this.pushConsumerSettings.isFifo()) {
            return new FifoConsumeService(this.clientId, this.processQueueTable, this.messageListener, this.consumptionExecutor, this, scheduler);
        }
        return new StandardConsumeService(this.clientId, this.processQueueTable, this.messageListener, this.consumptionExecutor, this, scheduler);
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public PushConsumerSettings getPushConsumerSettings() {
        return this.pushConsumerSettings;
    }

    public Map<String, FilterExpression> getSubscriptionExpressions() {
        return new HashMap<String, FilterExpression>(this.subscriptionExpressions);
    }

    public PushConsumer subscribe(String topic, FilterExpression filterExpression) throws ClientException {
        if (!this.isRunning()) {
            LOGGER.error("Unable to add subscription because push consumer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            throw new IllegalStateException("Push consumer is not running now");
        }
        ListenableFuture<TopicRouteData> future = this.getRouteData(topic);
        this.handleClientFuture(future);
        this.subscriptionExpressions.put(topic, filterExpression);
        return this;
    }

    public PushConsumer unsubscribe(String topic) {
        if (!this.isRunning()) {
            LOGGER.error("Unable to remove subscription because push consumer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            throw new IllegalStateException("Push consumer is not running now");
        }
        this.subscriptionExpressions.remove(topic);
        return this;
    }

    private ListenableFuture<Endpoints> pickEndpointsToQueryAssignments(String topic) {
        ListenableFuture<TopicRouteData> future = this.getRouteData(topic);
        return Futures.transformAsync(future, topicRouteData -> {
            Endpoints endpoints = topicRouteData.pickEndpointsToQueryAssignments();
            return Futures.immediateFuture((Object)endpoints);
        }, (Executor)MoreExecutors.directExecutor());
    }

    private QueryAssignmentRequest wrapQueryAssignmentRequest(String topic) {
        Resource topicResource = Resource.newBuilder().setName(topic).build();
        return QueryAssignmentRequest.newBuilder().setTopic(topicResource).setEndpoints(this.endpoints.toProtobuf()).setGroup(this.getProtobufGroup()).build();
    }

    ListenableFuture<Assignments> queryAssignment(String topic) {
        ListenableFuture<Endpoints> future = this.pickEndpointsToQueryAssignments(topic);
        ListenableFuture responseFuture = Futures.transformAsync(future, endpoints -> {
            Metadata metadata = this.sign();
            QueryAssignmentRequest request = this.wrapQueryAssignmentRequest(topic);
            Duration requestTimeout = this.clientConfiguration.getRequestTimeout();
            return this.clientManager.queryAssignment((Endpoints)endpoints, metadata, request, requestTimeout);
        }, (Executor)MoreExecutors.directExecutor());
        return Futures.transformAsync((ListenableFuture)responseFuture, context -> {
            QueryAssignmentResponse response = (QueryAssignmentResponse)context.getResponse();
            Status status = response.getStatus();
            Code code = status.getCode();
            int codeNumber = code.getNumber();
            String requestId = context.getContext().getRequestId();
            String statusMessage = status.getMessage();
            switch (code) {
                case OK: {
                    break;
                }
                case BAD_REQUEST: 
                case ILLEGAL_ACCESS_POINT: 
                case ILLEGAL_TOPIC: 
                case CLIENT_ID_REQUIRED: {
                    throw new BadRequestException(codeNumber, requestId, statusMessage);
                }
                case FORBIDDEN: {
                    throw new ForbiddenException(codeNumber, requestId, statusMessage);
                }
                case NOT_FOUND: 
                case TOPIC_NOT_FOUND: {
                    throw new NotFoundException(codeNumber, requestId, statusMessage);
                }
                case TOO_MANY_REQUESTS: {
                    throw new TooManyRequestsException(codeNumber, requestId, statusMessage);
                }
                case INTERNAL_ERROR: 
                case INTERNAL_SERVER_ERROR: {
                    throw new InternalErrorException(codeNumber, requestId, statusMessage);
                }
                case PROXY_TIMEOUT: {
                    throw new ProxyTimeoutException(codeNumber, requestId, statusMessage);
                }
                default: {
                    throw new UnsupportedException(codeNumber, requestId, statusMessage);
                }
            }
            List<Assignment> assignmentList = response.getAssignmentsList().stream().map(assignment -> new Assignment(new MessageQueueImpl(assignment.getMessageQueue()))).collect(Collectors.toList());
            Assignments assignments = new Assignments(assignmentList);
            return Futures.immediateFuture((Object)assignments);
        }, (Executor)MoreExecutors.directExecutor());
    }

    void dropProcessQueue(MessageQueueImpl mq) {
        ProcessQueue pq = (ProcessQueue)this.processQueueTable.remove(mq);
        if (null != pq) {
            pq.drop();
        }
    }

    protected Optional<ProcessQueue> createProcessQueue(MessageQueueImpl mq, FilterExpression filterExpression) {
        ProcessQueueImpl processQueue = new ProcessQueueImpl(this, mq, filterExpression);
        ProcessQueue previous = this.processQueueTable.putIfAbsent(mq, processQueue);
        if (null != previous) {
            return Optional.empty();
        }
        return Optional.of(processQueue);
    }

    @Override
    public HeartbeatRequest wrapHeartbeatRequest() {
        return HeartbeatRequest.newBuilder().setGroup(this.getProtobufGroup()).build();
    }

    @VisibleForTesting
    void syncProcessQueue(String topic, Assignments assignments, FilterExpression filterExpression) {
        HashSet<MessageQueueImpl> latest = new HashSet<MessageQueueImpl>();
        List<Assignment> assignmentList = assignments.getAssignmentList();
        for (Assignment assignment : assignmentList) {
            latest.add(assignment.getMessageQueue());
        }
        HashSet<MessageQueueImpl> activeMqs = new HashSet<MessageQueueImpl>();
        for (Map.Entry entry : this.processQueueTable.entrySet()) {
            MessageQueueImpl mq = (MessageQueueImpl)entry.getKey();
            ProcessQueue pq = (ProcessQueue)entry.getValue();
            if (!topic.equals(mq.getTopic())) continue;
            if (!latest.contains(mq)) {
                LOGGER.info("Drop message queue according to the latest assignmentList, mq={}, clientId={}", (Object)mq, (Object)this.clientId);
                this.dropProcessQueue(mq);
                continue;
            }
            if (pq.expired()) {
                LOGGER.warn("Drop message queue because it is expired, mq={}, clientId={}", (Object)mq, (Object)this.clientId);
                this.dropProcessQueue(mq);
                continue;
            }
            activeMqs.add(mq);
        }
        for (MessageQueueImpl mq : latest) {
            Optional<ProcessQueue> optionalProcessQueue;
            if (activeMqs.contains(mq) || !(optionalProcessQueue = this.createProcessQueue(mq, filterExpression)).isPresent()) continue;
            LOGGER.info("Start to fetch message from remote, mq={}, clientId={}", (Object)mq, (Object)this.clientId);
            optionalProcessQueue.get().fetchMessageImmediately();
        }
    }

    @VisibleForTesting
    void scanAssignments() {
        try {
            LOGGER.debug("Start to scan assignments periodically, clientId={}", (Object)this.clientId);
            for (Map.Entry<String, FilterExpression> entry : this.subscriptionExpressions.entrySet()) {
                final String topic = entry.getKey();
                final FilterExpression filterExpression = entry.getValue();
                final Assignments existed = (Assignments)this.cacheAssignments.get(topic);
                ListenableFuture<Assignments> future = this.queryAssignment(topic);
                Futures.addCallback(future, (FutureCallback)new FutureCallback<Assignments>(){

                    public void onSuccess(Assignments latest) {
                        if (latest.getAssignmentList().isEmpty()) {
                            if (null == existed || existed.getAssignmentList().isEmpty()) {
                                LOGGER.info("Acquired empty assignments from remote, would scan later, topic={}, clientId={}", (Object)topic, (Object)PushConsumerImpl.this.clientId);
                                return;
                            }
                            LOGGER.info("Attention!!! acquired empty assignments from remote, but existed assignments is not empty, topic={}, clientId={}", (Object)topic, (Object)PushConsumerImpl.this.clientId);
                        }
                        if (!latest.equals(existed)) {
                            LOGGER.info("Assignments of topic={} has changed, {} => {}, clientId={}", new Object[]{topic, existed, latest, PushConsumerImpl.this.clientId});
                            PushConsumerImpl.this.syncProcessQueue(topic, latest, filterExpression);
                            PushConsumerImpl.this.cacheAssignments.put(topic, latest);
                            return;
                        }
                        LOGGER.debug("Assignments of topic={} remains the same, assignments={}, clientId={}", new Object[]{topic, existed, PushConsumerImpl.this.clientId});
                        PushConsumerImpl.this.syncProcessQueue(topic, latest, filterExpression);
                    }

                    public void onFailure(Throwable t) {
                        LOGGER.error("Exception raised while scanning the assignments, topic={}, clientId={}", new Object[]{topic, PushConsumerImpl.this.clientId, t});
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Exception raised while scanning the assignments for all topics, clientId={}", (Object)this.clientId, (Object)t);
        }
    }

    @Override
    public ClientSettings getClientSettings() {
        return this.pushConsumerSettings;
    }

    public void close() {
        this.stopAsync().awaitTerminated();
    }

    int getQueueSize() {
        return this.processQueueTable.size();
    }

    int cacheMessageBytesThresholdPerQueue() {
        int size = this.getQueueSize();
        if (size <= 0) {
            return 0;
        }
        return Math.max(1, this.maxCacheMessageSizeInBytes / size);
    }

    int cacheMessageCountThresholdPerQueue() {
        int size = this.getQueueSize();
        if (size <= 0) {
            return 0;
        }
        return Math.max(1, this.maxCacheMessageCount / size);
    }

    public AtomicLong getReceptionTimes() {
        return this.receptionTimes;
    }

    public AtomicLong getReceivedMessagesQuantity() {
        return this.receivedMessagesQuantity;
    }

    public ConsumeService getConsumeService() {
        return this.consumeService;
    }

    @Override
    public void onVerifyMessageCommand(final Endpoints endpoints, VerifyMessageCommand verifyMessageCommand) {
        final String nonce = verifyMessageCommand.getNonce();
        MessageViewImpl messageView = MessageViewImpl.fromProtobuf(verifyMessageCommand.getMessage());
        final MessageId messageId = messageView.getMessageId();
        ListenableFuture<ConsumeResult> future = this.consumeService.consume(messageView);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<ConsumeResult>(){

            public void onSuccess(ConsumeResult consumeResult) {
                Code code = ConsumeResult.SUCCESS.equals((Object)consumeResult) ? Code.OK : Code.FAILED_TO_CONSUME_MESSAGE;
                Status status = Status.newBuilder().setCode(code).build();
                VerifyMessageResult verifyMessageResult = VerifyMessageResult.newBuilder().setNonce(nonce).build();
                TelemetryCommand command = TelemetryCommand.newBuilder().setVerifyMessageResult(verifyMessageResult).setStatus(status).build();
                try {
                    PushConsumerImpl.this.telemetry(endpoints, command);
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to send message verification result command, endpoints={}, command={}, messageId={}, clientId={}", new Object[]{endpoints, command, messageId, PushConsumerImpl.this.clientId, t});
                }
            }

            public void onFailure(Throwable t) {
                LOGGER.error("[Bug] Failed to get message verification result, endpoints={}, messageId={}, clientId={}", new Object[]{endpoints, messageId, PushConsumerImpl.this.clientId, t});
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ForwardMessageToDeadLetterQueueRequest wrapForwardMessageToDeadLetterQueueRequest(MessageViewImpl messageView) {
        Resource topicResource = Resource.newBuilder().setName(messageView.getTopic()).build();
        return ForwardMessageToDeadLetterQueueRequest.newBuilder().setGroup(this.getProtobufGroup()).setTopic(topicResource).setReceiptHandle(messageView.getReceiptHandle()).setMessageId(messageView.getMessageId().toString()).setDeliveryAttempt(messageView.getDeliveryAttempt()).setMaxDeliveryAttempts(this.getRetryPolicy().getMaxAttempts()).build();
    }

    public ListenableFuture<RpcInvocation<ForwardMessageToDeadLetterQueueResponse>> forwardMessageToDeadLetterQueue(MessageViewImpl messageView) {
        ListenableFuture<RpcInvocation<ForwardMessageToDeadLetterQueueResponse>> future;
        final Stopwatch stopwatch = Stopwatch.createStarted();
        final List<MessageCommon> messageCommons = Collections.singletonList(messageView.getMessageCommon());
        this.doBefore(MessageHookPoints.FORWARD_TO_DLQ, messageCommons);
        Endpoints endpoints = messageView.getEndpoints();
        try {
            ForwardMessageToDeadLetterQueueRequest request = this.wrapForwardMessageToDeadLetterQueueRequest(messageView);
            Metadata metadata = this.sign();
            future = this.clientManager.forwardMessageToDeadLetterQueue(endpoints, metadata, request, this.clientConfiguration.getRequestTimeout());
        }
        catch (Throwable t) {
            future = Futures.immediateFailedFuture((Throwable)t);
        }
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<RpcInvocation<ForwardMessageToDeadLetterQueueResponse>>(){

            public void onSuccess(RpcInvocation<ForwardMessageToDeadLetterQueueResponse> invocation) {
                ForwardMessageToDeadLetterQueueResponse response = invocation.getResponse();
                Duration duration = stopwatch.elapsed();
                MessageHookPointsStatus messageHookPointsStatus = Code.OK.equals((Object)response.getStatus().getCode()) ? MessageHookPointsStatus.OK : MessageHookPointsStatus.ERROR;
                PushConsumerImpl.this.doAfter(MessageHookPoints.FORWARD_TO_DLQ, messageCommons, duration, messageHookPointsStatus);
            }

            public void onFailure(Throwable t) {
                Duration duration = stopwatch.elapsed();
                PushConsumerImpl.this.doAfter(MessageHookPoints.FORWARD_TO_DLQ, messageCommons, duration, MessageHookPointsStatus.ERROR);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    @Override
    public void doStats() {
        long receptionTimes = this.receptionTimes.getAndSet(0L);
        long receivedMessagesQuantity = this.receivedMessagesQuantity.getAndSet(0L);
        long consumptionOkQuantity = this.consumptionOkQuantity.getAndSet(0L);
        long consumptionErrorQuantity = this.consumptionErrorQuantity.getAndSet(0L);
        LOGGER.info("clientId={}, consumerGroup={}, receptionTimes={}, receivedMessagesQuantity={}, consumptionOkQuantity={}, consumptionErrorQuantity={}", new Object[]{this.clientId, this.consumerGroup, receptionTimes, receivedMessagesQuantity, consumptionOkQuantity, consumptionErrorQuantity});
        this.processQueueTable.values().forEach(ProcessQueue::doStats);
    }

    public RetryPolicy getRetryPolicy() {
        return this.pushConsumerSettings.getRetryPolicy();
    }

    public ThreadPoolExecutor getConsumptionExecutor() {
        return this.consumptionExecutor;
    }

    @Override
    public Map<String, Long> getCachedMessageCount() {
        HashMap<String, Long> cachedMessageCountMap = new HashMap<String, Long>();
        for (ProcessQueue pq : this.processQueueTable.values()) {
            String topic = pq.getMessageQueue().getTopic();
            long count = cachedMessageCountMap.containsKey(topic) ? (Long)cachedMessageCountMap.get(topic) : 0L;
            count += pq.getInflightMessageCount();
            cachedMessageCountMap.put(topic, count += pq.getPendingMessageCount());
        }
        return cachedMessageCountMap;
    }

    @Override
    public Map<String, Long> getCachedMessageBytes() {
        HashMap<String, Long> cachedMessageBytesMap = new HashMap<String, Long>();
        for (ProcessQueue pq : this.processQueueTable.values()) {
            String topic = pq.getMessageQueue().getTopic();
            long bytes = cachedMessageBytesMap.containsKey(topic) ? (Long)cachedMessageBytesMap.get(topic) : 0L;
            cachedMessageBytesMap.put(topic, bytes += pq.getCachedMessageBytes());
        }
        return cachedMessageBytesMap;
    }
}

