/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.nio.CharBuffer;
import org.apache.pulsar.common.util.NumberFormat;

public class SimpleTextOutputStream {
    private final ByteBuf buffer;
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final CharBuffer singleCharBuffer = CharBuffer.allocate(1);

    public SimpleTextOutputStream(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public SimpleTextOutputStream write(byte[] a) {
        this.buffer.writeBytes(a, 0, a.length);
        return this;
    }

    public SimpleTextOutputStream write(byte[] a, int offset, int len) {
        this.buffer.writeBytes(a, offset, len);
        return this;
    }

    public SimpleTextOutputStream write(char c) {
        if (c <= '\u007f') {
            this.buffer.writeByte((int)((byte)c));
            return this;
        }
        this.singleCharBuffer.put(0, c);
        this.buffer.writeCharSequence((CharSequence)this.singleCharBuffer, CharsetUtil.UTF_8);
        return this;
    }

    public SimpleTextOutputStream write(String s) {
        if (s == null) {
            return this;
        }
        this.buffer.writeCharSequence((CharSequence)s, CharsetUtil.UTF_8);
        return this;
    }

    public SimpleTextOutputStream write(CharSequence s) {
        if (s == null) {
            return this;
        }
        this.buffer.writeCharSequence(s, CharsetUtil.UTF_8);
        return this;
    }

    public SimpleTextOutputStream write(Number n) {
        if (n instanceof Integer) {
            return this.write(n.intValue());
        }
        if (n instanceof Long) {
            return this.write(n.longValue());
        }
        if (n instanceof Double) {
            return this.write(n.doubleValue());
        }
        return this.write(n.toString());
    }

    public SimpleTextOutputStream writeEncoded(String s) {
        if (s == null) {
            return this;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c < ' ' || c > '~') {
                this.buffer.writeByte(92);
                this.buffer.writeByte(117);
                this.buffer.writeByte((int)hexChars[(c & 0xF000) >> 12]);
                this.buffer.writeByte((int)hexChars[(c & 0xF00) >> 8]);
                this.buffer.writeByte((int)hexChars[(c & 0xF0) >> 4]);
                this.buffer.writeByte((int)hexChars[c & 0xF]);
                continue;
            }
            if (c == '\\' || c == '\"') {
                this.buffer.writeByte(92);
            }
            this.buffer.writeByte((int)((byte)c));
        }
        return this;
    }

    public SimpleTextOutputStream write(boolean b) {
        this.write(b ? "true" : "false");
        return this;
    }

    public SimpleTextOutputStream write(long n) {
        NumberFormat.format(this.buffer, n);
        return this;
    }

    public SimpleTextOutputStream write(double d) {
        long i = (long)d;
        this.write(i);
        long r = Math.abs((long)(1000.0 * (d - (double)i)));
        this.write('.');
        if (r == 0L) {
            this.write('0');
            return this;
        }
        if (r < 100L) {
            this.write('0');
        }
        if (r < 10L) {
            this.write('0');
        }
        this.write(r);
        return this;
    }

    public void write(ByteBuf byteBuf) {
        this.buffer.writeBytes(byteBuf);
    }

    public ByteBuf getBuffer() {
        return this.buffer;
    }

    public void writeByte(int b) {
        this.buffer.writeByte(b);
    }
}

