/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableOutput is an enum
type OpcuaNodeIdServicesVariableOutput int32

type IOpcuaNodeIdServicesVariableOutput interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableOutput_OutputArguments OpcuaNodeIdServicesVariableOutput = 3073
)

var OpcuaNodeIdServicesVariableOutputValues []OpcuaNodeIdServicesVariableOutput

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableOutputValues = []OpcuaNodeIdServicesVariableOutput{
		OpcuaNodeIdServicesVariableOutput_OutputArguments,
	}
}

func OpcuaNodeIdServicesVariableOutputByValue(value int32) (enum OpcuaNodeIdServicesVariableOutput, ok bool) {
	switch value {
	case 3073:
		return OpcuaNodeIdServicesVariableOutput_OutputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableOutputByName(value string) (enum OpcuaNodeIdServicesVariableOutput, ok bool) {
	switch value {
	case "OutputArguments":
		return OpcuaNodeIdServicesVariableOutput_OutputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableOutputKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableOutputValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableOutput(structType any) OpcuaNodeIdServicesVariableOutput {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableOutput {
		if sOpcuaNodeIdServicesVariableOutput, ok := typ.(OpcuaNodeIdServicesVariableOutput); ok {
			return sOpcuaNodeIdServicesVariableOutput
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableOutput) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableOutput) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableOutputParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableOutput, error) {
	return OpcuaNodeIdServicesVariableOutputParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableOutputParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableOutput, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableOutput", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableOutput")
	}
	if enum, ok := OpcuaNodeIdServicesVariableOutputByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableOutput")
		return OpcuaNodeIdServicesVariableOutput(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableOutput) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableOutput) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableOutput", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableOutput) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableOutput) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableOutput_OutputArguments:
		return "OutputArguments"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableOutput) String() string {
	return e.PLC4XEnumName()
}
