/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// IdentifyReplyCommandMaximumLevels is the corresponding interface of IdentifyReplyCommandMaximumLevels
type IdentifyReplyCommandMaximumLevels interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	IdentifyReplyCommand
	// GetMaximumLevels returns MaximumLevels (property field)
	GetMaximumLevels() []byte
	// IsIdentifyReplyCommandMaximumLevels is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsIdentifyReplyCommandMaximumLevels()
	// CreateBuilder creates a IdentifyReplyCommandMaximumLevelsBuilder
	CreateIdentifyReplyCommandMaximumLevelsBuilder() IdentifyReplyCommandMaximumLevelsBuilder
}

// _IdentifyReplyCommandMaximumLevels is the data-structure of this message
type _IdentifyReplyCommandMaximumLevels struct {
	IdentifyReplyCommandContract
	MaximumLevels []byte
}

var _ IdentifyReplyCommandMaximumLevels = (*_IdentifyReplyCommandMaximumLevels)(nil)
var _ IdentifyReplyCommandRequirements = (*_IdentifyReplyCommandMaximumLevels)(nil)

// NewIdentifyReplyCommandMaximumLevels factory function for _IdentifyReplyCommandMaximumLevels
func NewIdentifyReplyCommandMaximumLevels(maximumLevels []byte, numBytes uint8) *_IdentifyReplyCommandMaximumLevels {
	_result := &_IdentifyReplyCommandMaximumLevels{
		IdentifyReplyCommandContract: NewIdentifyReplyCommand(numBytes),
		MaximumLevels:                maximumLevels,
	}
	_result.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// IdentifyReplyCommandMaximumLevelsBuilder is a builder for IdentifyReplyCommandMaximumLevels
type IdentifyReplyCommandMaximumLevelsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(maximumLevels []byte) IdentifyReplyCommandMaximumLevelsBuilder
	// WithMaximumLevels adds MaximumLevels (property field)
	WithMaximumLevels(...byte) IdentifyReplyCommandMaximumLevelsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() IdentifyReplyCommandBuilder
	// Build builds the IdentifyReplyCommandMaximumLevels or returns an error if something is wrong
	Build() (IdentifyReplyCommandMaximumLevels, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() IdentifyReplyCommandMaximumLevels
}

// NewIdentifyReplyCommandMaximumLevelsBuilder() creates a IdentifyReplyCommandMaximumLevelsBuilder
func NewIdentifyReplyCommandMaximumLevelsBuilder() IdentifyReplyCommandMaximumLevelsBuilder {
	return &_IdentifyReplyCommandMaximumLevelsBuilder{_IdentifyReplyCommandMaximumLevels: new(_IdentifyReplyCommandMaximumLevels)}
}

type _IdentifyReplyCommandMaximumLevelsBuilder struct {
	*_IdentifyReplyCommandMaximumLevels

	parentBuilder *_IdentifyReplyCommandBuilder

	collectedErr []error
}

var _ (IdentifyReplyCommandMaximumLevelsBuilder) = (*_IdentifyReplyCommandMaximumLevelsBuilder)(nil)

func (b *_IdentifyReplyCommandMaximumLevelsBuilder) setParent(contract IdentifyReplyCommandContract) {
	b.IdentifyReplyCommandContract = contract
	contract.(*_IdentifyReplyCommand)._SubType = b._IdentifyReplyCommandMaximumLevels
}

func (b *_IdentifyReplyCommandMaximumLevelsBuilder) WithMandatoryFields(maximumLevels []byte) IdentifyReplyCommandMaximumLevelsBuilder {
	return b.WithMaximumLevels(maximumLevels...)
}

func (b *_IdentifyReplyCommandMaximumLevelsBuilder) WithMaximumLevels(maximumLevels ...byte) IdentifyReplyCommandMaximumLevelsBuilder {
	b.MaximumLevels = maximumLevels
	return b
}

func (b *_IdentifyReplyCommandMaximumLevelsBuilder) Build() (IdentifyReplyCommandMaximumLevels, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._IdentifyReplyCommandMaximumLevels.deepCopy(), nil
}

func (b *_IdentifyReplyCommandMaximumLevelsBuilder) MustBuild() IdentifyReplyCommandMaximumLevels {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_IdentifyReplyCommandMaximumLevelsBuilder) Done() IdentifyReplyCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewIdentifyReplyCommandBuilder().(*_IdentifyReplyCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_IdentifyReplyCommandMaximumLevelsBuilder) buildForIdentifyReplyCommand() (IdentifyReplyCommand, error) {
	return b.Build()
}

func (b *_IdentifyReplyCommandMaximumLevelsBuilder) DeepCopy() any {
	_copy := b.CreateIdentifyReplyCommandMaximumLevelsBuilder().(*_IdentifyReplyCommandMaximumLevelsBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateIdentifyReplyCommandMaximumLevelsBuilder creates a IdentifyReplyCommandMaximumLevelsBuilder
func (b *_IdentifyReplyCommandMaximumLevels) CreateIdentifyReplyCommandMaximumLevelsBuilder() IdentifyReplyCommandMaximumLevelsBuilder {
	if b == nil {
		return NewIdentifyReplyCommandMaximumLevelsBuilder()
	}
	return &_IdentifyReplyCommandMaximumLevelsBuilder{_IdentifyReplyCommandMaximumLevels: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_IdentifyReplyCommandMaximumLevels) GetAttribute() Attribute {
	return Attribute_MaximumLevels
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_IdentifyReplyCommandMaximumLevels) GetParent() IdentifyReplyCommandContract {
	return m.IdentifyReplyCommandContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_IdentifyReplyCommandMaximumLevels) GetMaximumLevels() []byte {
	return m.MaximumLevels
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastIdentifyReplyCommandMaximumLevels(structType any) IdentifyReplyCommandMaximumLevels {
	if casted, ok := structType.(IdentifyReplyCommandMaximumLevels); ok {
		return casted
	}
	if casted, ok := structType.(*IdentifyReplyCommandMaximumLevels); ok {
		return *casted
	}
	return nil
}

func (m *_IdentifyReplyCommandMaximumLevels) GetTypeName() string {
	return "IdentifyReplyCommandMaximumLevels"
}

func (m *_IdentifyReplyCommandMaximumLevels) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).getLengthInBits(ctx))

	// Array field
	if len(m.MaximumLevels) > 0 {
		lengthInBits += 8 * uint16(len(m.MaximumLevels))
	}

	return lengthInBits
}

func (m *_IdentifyReplyCommandMaximumLevels) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_IdentifyReplyCommandMaximumLevels) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_IdentifyReplyCommand, attribute Attribute, numBytes uint8) (__identifyReplyCommandMaximumLevels IdentifyReplyCommandMaximumLevels, err error) {
	m.IdentifyReplyCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("IdentifyReplyCommandMaximumLevels"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for IdentifyReplyCommandMaximumLevels")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	maximumLevels, err := readBuffer.ReadByteArray("maximumLevels", int(numBytes))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'maximumLevels' field"))
	}
	m.MaximumLevels = maximumLevels

	if closeErr := readBuffer.CloseContext("IdentifyReplyCommandMaximumLevels"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for IdentifyReplyCommandMaximumLevels")
	}

	return m, nil
}

func (m *_IdentifyReplyCommandMaximumLevels) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_IdentifyReplyCommandMaximumLevels) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("IdentifyReplyCommandMaximumLevels"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for IdentifyReplyCommandMaximumLevels")
		}

		if err := WriteByteArrayField(ctx, "maximumLevels", m.GetMaximumLevels(), WriteByteArray(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'maximumLevels' field")
		}

		if popErr := writeBuffer.PopContext("IdentifyReplyCommandMaximumLevels"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for IdentifyReplyCommandMaximumLevels")
		}
		return nil
	}
	return m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_IdentifyReplyCommandMaximumLevels) IsIdentifyReplyCommandMaximumLevels() {}

func (m *_IdentifyReplyCommandMaximumLevels) DeepCopy() any {
	return m.deepCopy()
}

func (m *_IdentifyReplyCommandMaximumLevels) deepCopy() *_IdentifyReplyCommandMaximumLevels {
	if m == nil {
		return nil
	}
	_IdentifyReplyCommandMaximumLevelsCopy := &_IdentifyReplyCommandMaximumLevels{
		m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).deepCopy(),
		utils.DeepCopySlice[byte, byte](m.MaximumLevels),
	}
	_IdentifyReplyCommandMaximumLevelsCopy.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = m
	return _IdentifyReplyCommandMaximumLevelsCopy
}

func (m *_IdentifyReplyCommandMaximumLevels) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
