/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataFileSize is the corresponding interface of BACnetConstructedDataFileSize
type BACnetConstructedDataFileSize interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetFileSize returns FileSize (property field)
	GetFileSize() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataFileSize is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataFileSize()
	// CreateBuilder creates a BACnetConstructedDataFileSizeBuilder
	CreateBACnetConstructedDataFileSizeBuilder() BACnetConstructedDataFileSizeBuilder
}

// _BACnetConstructedDataFileSize is the data-structure of this message
type _BACnetConstructedDataFileSize struct {
	BACnetConstructedDataContract
	FileSize BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataFileSize = (*_BACnetConstructedDataFileSize)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataFileSize)(nil)

// NewBACnetConstructedDataFileSize factory function for _BACnetConstructedDataFileSize
func NewBACnetConstructedDataFileSize(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, fileSize BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataFileSize {
	if fileSize == nil {
		panic("fileSize of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataFileSize must not be nil")
	}
	_result := &_BACnetConstructedDataFileSize{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		FileSize:                      fileSize,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataFileSizeBuilder is a builder for BACnetConstructedDataFileSize
type BACnetConstructedDataFileSizeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(fileSize BACnetApplicationTagUnsignedInteger) BACnetConstructedDataFileSizeBuilder
	// WithFileSize adds FileSize (property field)
	WithFileSize(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataFileSizeBuilder
	// WithFileSizeBuilder adds FileSize (property field) which is build by the builder
	WithFileSizeBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataFileSizeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataFileSize or returns an error if something is wrong
	Build() (BACnetConstructedDataFileSize, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataFileSize
}

// NewBACnetConstructedDataFileSizeBuilder() creates a BACnetConstructedDataFileSizeBuilder
func NewBACnetConstructedDataFileSizeBuilder() BACnetConstructedDataFileSizeBuilder {
	return &_BACnetConstructedDataFileSizeBuilder{_BACnetConstructedDataFileSize: new(_BACnetConstructedDataFileSize)}
}

type _BACnetConstructedDataFileSizeBuilder struct {
	*_BACnetConstructedDataFileSize

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataFileSizeBuilder) = (*_BACnetConstructedDataFileSizeBuilder)(nil)

func (b *_BACnetConstructedDataFileSizeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataFileSize
}

func (b *_BACnetConstructedDataFileSizeBuilder) WithMandatoryFields(fileSize BACnetApplicationTagUnsignedInteger) BACnetConstructedDataFileSizeBuilder {
	return b.WithFileSize(fileSize)
}

func (b *_BACnetConstructedDataFileSizeBuilder) WithFileSize(fileSize BACnetApplicationTagUnsignedInteger) BACnetConstructedDataFileSizeBuilder {
	b.FileSize = fileSize
	return b
}

func (b *_BACnetConstructedDataFileSizeBuilder) WithFileSizeBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataFileSizeBuilder {
	builder := builderSupplier(b.FileSize.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.FileSize, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataFileSizeBuilder) Build() (BACnetConstructedDataFileSize, error) {
	if b.FileSize == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'fileSize' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataFileSize.deepCopy(), nil
}

func (b *_BACnetConstructedDataFileSizeBuilder) MustBuild() BACnetConstructedDataFileSize {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataFileSizeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataFileSizeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataFileSizeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataFileSizeBuilder().(*_BACnetConstructedDataFileSizeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataFileSizeBuilder creates a BACnetConstructedDataFileSizeBuilder
func (b *_BACnetConstructedDataFileSize) CreateBACnetConstructedDataFileSizeBuilder() BACnetConstructedDataFileSizeBuilder {
	if b == nil {
		return NewBACnetConstructedDataFileSizeBuilder()
	}
	return &_BACnetConstructedDataFileSizeBuilder{_BACnetConstructedDataFileSize: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataFileSize) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataFileSize) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_FILE_SIZE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataFileSize) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataFileSize) GetFileSize() BACnetApplicationTagUnsignedInteger {
	return m.FileSize
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataFileSize) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetFileSize())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataFileSize(structType any) BACnetConstructedDataFileSize {
	if casted, ok := structType.(BACnetConstructedDataFileSize); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataFileSize); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataFileSize) GetTypeName() string {
	return "BACnetConstructedDataFileSize"
}

func (m *_BACnetConstructedDataFileSize) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (fileSize)
	lengthInBits += m.FileSize.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataFileSize) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataFileSize) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataFileSize BACnetConstructedDataFileSize, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataFileSize"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataFileSize")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	fileSize, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "fileSize", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'fileSize' field"))
	}
	m.FileSize = fileSize

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), fileSize)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataFileSize"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataFileSize")
	}

	return m, nil
}

func (m *_BACnetConstructedDataFileSize) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataFileSize) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataFileSize"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataFileSize")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "fileSize", m.GetFileSize(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'fileSize' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataFileSize"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataFileSize")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataFileSize) IsBACnetConstructedDataFileSize() {}

func (m *_BACnetConstructedDataFileSize) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataFileSize) deepCopy() *_BACnetConstructedDataFileSize {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataFileSizeCopy := &_BACnetConstructedDataFileSize{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.FileSize),
	}
	_BACnetConstructedDataFileSizeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataFileSizeCopy
}

func (m *_BACnetConstructedDataFileSize) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
