/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetChannelValueObjectidentifier is the corresponding interface of BACnetChannelValueObjectidentifier
type BACnetChannelValueObjectidentifier interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetChannelValue
	// GetObjectidentifierValue returns ObjectidentifierValue (property field)
	GetObjectidentifierValue() BACnetApplicationTagObjectIdentifier
	// IsBACnetChannelValueObjectidentifier is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetChannelValueObjectidentifier()
	// CreateBuilder creates a BACnetChannelValueObjectidentifierBuilder
	CreateBACnetChannelValueObjectidentifierBuilder() BACnetChannelValueObjectidentifierBuilder
}

// _BACnetChannelValueObjectidentifier is the data-structure of this message
type _BACnetChannelValueObjectidentifier struct {
	BACnetChannelValueContract
	ObjectidentifierValue BACnetApplicationTagObjectIdentifier
}

var _ BACnetChannelValueObjectidentifier = (*_BACnetChannelValueObjectidentifier)(nil)
var _ BACnetChannelValueRequirements = (*_BACnetChannelValueObjectidentifier)(nil)

// NewBACnetChannelValueObjectidentifier factory function for _BACnetChannelValueObjectidentifier
func NewBACnetChannelValueObjectidentifier(peekedTagHeader BACnetTagHeader, objectidentifierValue BACnetApplicationTagObjectIdentifier) *_BACnetChannelValueObjectidentifier {
	if objectidentifierValue == nil {
		panic("objectidentifierValue of type BACnetApplicationTagObjectIdentifier for BACnetChannelValueObjectidentifier must not be nil")
	}
	_result := &_BACnetChannelValueObjectidentifier{
		BACnetChannelValueContract: NewBACnetChannelValue(peekedTagHeader),
		ObjectidentifierValue:      objectidentifierValue,
	}
	_result.BACnetChannelValueContract.(*_BACnetChannelValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetChannelValueObjectidentifierBuilder is a builder for BACnetChannelValueObjectidentifier
type BACnetChannelValueObjectidentifierBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectidentifierValue BACnetApplicationTagObjectIdentifier) BACnetChannelValueObjectidentifierBuilder
	// WithObjectidentifierValue adds ObjectidentifierValue (property field)
	WithObjectidentifierValue(BACnetApplicationTagObjectIdentifier) BACnetChannelValueObjectidentifierBuilder
	// WithObjectidentifierValueBuilder adds ObjectidentifierValue (property field) which is build by the builder
	WithObjectidentifierValueBuilder(func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetChannelValueObjectidentifierBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetChannelValueBuilder
	// Build builds the BACnetChannelValueObjectidentifier or returns an error if something is wrong
	Build() (BACnetChannelValueObjectidentifier, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetChannelValueObjectidentifier
}

// NewBACnetChannelValueObjectidentifierBuilder() creates a BACnetChannelValueObjectidentifierBuilder
func NewBACnetChannelValueObjectidentifierBuilder() BACnetChannelValueObjectidentifierBuilder {
	return &_BACnetChannelValueObjectidentifierBuilder{_BACnetChannelValueObjectidentifier: new(_BACnetChannelValueObjectidentifier)}
}

type _BACnetChannelValueObjectidentifierBuilder struct {
	*_BACnetChannelValueObjectidentifier

	parentBuilder *_BACnetChannelValueBuilder

	collectedErr []error
}

var _ (BACnetChannelValueObjectidentifierBuilder) = (*_BACnetChannelValueObjectidentifierBuilder)(nil)

func (b *_BACnetChannelValueObjectidentifierBuilder) setParent(contract BACnetChannelValueContract) {
	b.BACnetChannelValueContract = contract
	contract.(*_BACnetChannelValue)._SubType = b._BACnetChannelValueObjectidentifier
}

func (b *_BACnetChannelValueObjectidentifierBuilder) WithMandatoryFields(objectidentifierValue BACnetApplicationTagObjectIdentifier) BACnetChannelValueObjectidentifierBuilder {
	return b.WithObjectidentifierValue(objectidentifierValue)
}

func (b *_BACnetChannelValueObjectidentifierBuilder) WithObjectidentifierValue(objectidentifierValue BACnetApplicationTagObjectIdentifier) BACnetChannelValueObjectidentifierBuilder {
	b.ObjectidentifierValue = objectidentifierValue
	return b
}

func (b *_BACnetChannelValueObjectidentifierBuilder) WithObjectidentifierValueBuilder(builderSupplier func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetChannelValueObjectidentifierBuilder {
	builder := builderSupplier(b.ObjectidentifierValue.CreateBACnetApplicationTagObjectIdentifierBuilder())
	var err error
	b.ObjectidentifierValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetChannelValueObjectidentifierBuilder) Build() (BACnetChannelValueObjectidentifier, error) {
	if b.ObjectidentifierValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'objectidentifierValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetChannelValueObjectidentifier.deepCopy(), nil
}

func (b *_BACnetChannelValueObjectidentifierBuilder) MustBuild() BACnetChannelValueObjectidentifier {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetChannelValueObjectidentifierBuilder) Done() BACnetChannelValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetChannelValueBuilder().(*_BACnetChannelValueBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetChannelValueObjectidentifierBuilder) buildForBACnetChannelValue() (BACnetChannelValue, error) {
	return b.Build()
}

func (b *_BACnetChannelValueObjectidentifierBuilder) DeepCopy() any {
	_copy := b.CreateBACnetChannelValueObjectidentifierBuilder().(*_BACnetChannelValueObjectidentifierBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetChannelValueObjectidentifierBuilder creates a BACnetChannelValueObjectidentifierBuilder
func (b *_BACnetChannelValueObjectidentifier) CreateBACnetChannelValueObjectidentifierBuilder() BACnetChannelValueObjectidentifierBuilder {
	if b == nil {
		return NewBACnetChannelValueObjectidentifierBuilder()
	}
	return &_BACnetChannelValueObjectidentifierBuilder{_BACnetChannelValueObjectidentifier: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetChannelValueObjectidentifier) GetParent() BACnetChannelValueContract {
	return m.BACnetChannelValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetChannelValueObjectidentifier) GetObjectidentifierValue() BACnetApplicationTagObjectIdentifier {
	return m.ObjectidentifierValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetChannelValueObjectidentifier(structType any) BACnetChannelValueObjectidentifier {
	if casted, ok := structType.(BACnetChannelValueObjectidentifier); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetChannelValueObjectidentifier); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetChannelValueObjectidentifier) GetTypeName() string {
	return "BACnetChannelValueObjectidentifier"
}

func (m *_BACnetChannelValueObjectidentifier) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetChannelValueContract.(*_BACnetChannelValue).getLengthInBits(ctx))

	// Simple field (objectidentifierValue)
	lengthInBits += m.ObjectidentifierValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetChannelValueObjectidentifier) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetChannelValueObjectidentifier) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetChannelValue) (__bACnetChannelValueObjectidentifier BACnetChannelValueObjectidentifier, err error) {
	m.BACnetChannelValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetChannelValueObjectidentifier"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetChannelValueObjectidentifier")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	objectidentifierValue, err := ReadSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "objectidentifierValue", ReadComplex[BACnetApplicationTagObjectIdentifier](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagObjectIdentifier](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectidentifierValue' field"))
	}
	m.ObjectidentifierValue = objectidentifierValue

	if closeErr := readBuffer.CloseContext("BACnetChannelValueObjectidentifier"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetChannelValueObjectidentifier")
	}

	return m, nil
}

func (m *_BACnetChannelValueObjectidentifier) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetChannelValueObjectidentifier) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetChannelValueObjectidentifier"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetChannelValueObjectidentifier")
		}

		if err := WriteSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "objectidentifierValue", m.GetObjectidentifierValue(), WriteComplex[BACnetApplicationTagObjectIdentifier](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'objectidentifierValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetChannelValueObjectidentifier"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetChannelValueObjectidentifier")
		}
		return nil
	}
	return m.BACnetChannelValueContract.(*_BACnetChannelValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetChannelValueObjectidentifier) IsBACnetChannelValueObjectidentifier() {}

func (m *_BACnetChannelValueObjectidentifier) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetChannelValueObjectidentifier) deepCopy() *_BACnetChannelValueObjectidentifier {
	if m == nil {
		return nil
	}
	_BACnetChannelValueObjectidentifierCopy := &_BACnetChannelValueObjectidentifier{
		m.BACnetChannelValueContract.(*_BACnetChannelValue).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagObjectIdentifier](m.ObjectidentifierValue),
	}
	_BACnetChannelValueObjectidentifierCopy.BACnetChannelValueContract.(*_BACnetChannelValue)._SubType = m
	return _BACnetChannelValueObjectidentifierCopy
}

func (m *_BACnetChannelValueObjectidentifier) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
