/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import org.apache.openjpa.persistence.query.AbstractVisitable;
import org.apache.openjpa.persistence.query.AliasContext;
import org.apache.openjpa.persistence.query.AndPredicate;
import org.apache.openjpa.persistence.query.BinaryConditionalOperator;
import org.apache.openjpa.persistence.query.Expression;
import org.apache.openjpa.persistence.query.OrPredicate;
import org.apache.openjpa.persistence.query.Predicate;
import org.apache.openjpa.persistence.query.QueryDefinitionImpl;
import org.apache.openjpa.persistence.query.Visitable;

class BinaryExpressionPredicate
extends AbstractVisitable
implements Predicate,
Visitable {
    private static final long serialVersionUID = 1L;
    protected final Expression _e1;
    protected final Expression _e2;
    protected final BinaryConditionalOperator _op;
    private final BinaryConditionalOperator _nop;
    private static final StringBuffer SPACE = new StringBuffer(" ");

    BinaryExpressionPredicate(Expression e1, BinaryConditionalOperator op, BinaryConditionalOperator nop, Expression e2) {
        this._e1 = e1;
        this._e2 = e2;
        this._op = op;
        this._nop = nop;
    }

    public final Expression getOperand() {
        return this._e1;
    }

    public final Expression getOperand2() {
        return this._e2;
    }

    public final BinaryConditionalOperator getOperator() {
        return this._op;
    }

    @Override
    public Predicate and(Predicate predicate) {
        return new AndPredicate(this, predicate);
    }

    @Override
    public Predicate or(Predicate predicate) {
        return new OrPredicate(this, predicate);
    }

    @Override
    public Predicate not() {
        if (this._nop == null) {
            throw new UnsupportedOperationException(this.toString());
        }
        return new BinaryExpressionPredicate(this._e1, this._nop, this._op, this._e2);
    }

    @Override
    public String asExpression(AliasContext ctx) {
        return this.asExpression((Visitable)((Object)this._e1), ctx) + String.valueOf(SPACE) + String.valueOf((Object)this._op) + String.valueOf(SPACE) + this.asExpression((Visitable)((Object)this._e2), ctx);
    }

    String asExpression(Visitable v, AliasContext ctx) {
        String result = v.asExpression(ctx);
        if (v instanceof QueryDefinitionImpl) {
            return "(" + result + ")";
        }
        return result;
    }
}

