/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class SliceThread
extends Thread {
    private final Thread _parent;
    private static ExecutorService _pool;

    public SliceThread(String name, Thread parent, Runnable r) {
        super(r, name);
        this._parent = parent;
    }

    public SliceThread(Thread parent, Runnable r) {
        super(r);
        this._parent = parent;
    }

    public Thread getParent() {
        return this._parent;
    }

    public static ExecutorService getPool() {
        if (_pool == null) {
            _pool = Executors.newCachedThreadPool(new SliceThreadFactory());
        }
        return _pool;
    }

    private static class SliceThreadFactory
    implements ThreadFactory {
        int n = 0;

        private SliceThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread parent = Thread.currentThread();
            return new SliceThread(parent.getName() + "-slice-" + this.n++, parent, r);
        }
    }
}

