/****************************************************************************
 * arch/arm/src/cxd56xx/cxd56_scufifo.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_ARM_SRC_CXD56XX_CXD56_SCUFIFO_H
#define __ARCH_ARM_SRC_CXD56XX_CXD56_SCUFIFO_H

/****************************************************************************
 * include files
 ****************************************************************************/

#define FIFOMEM_INVALID 0xffff

/****************************************************************************
 * Name: scufifo_initialize
 *
 * Description:
 *   Initialize SCU FIFO memory management
 *
 ****************************************************************************/

void scufifo_initialize(void);

/****************************************************************************
 * Name: scufifo_memalloc
 *
 * Description:
 *   Allocate SCU FIFO memory
 *
 * Input Parameters:
 *   size - Request memory size
 *
 * Returned Value:
 *   Allocated FIFO memory start offset. If error, return FIFOMEM_INVALID.
 *
 ****************************************************************************/

uint16_t scufifo_memalloc(uint16_t size);

/****************************************************************************
 * Name: scufifo_memfree
 *
 * Description:
 *   Free allocated SCU FIFO memory
 *
 * Input Parameters:
 *   start - Start offset of FIFO memory
 *
 ****************************************************************************/

void scufifo_memfree(uint16_t start);

#endif /* __ARCH_ARM_SRC_CXD56XX_CXD56_SCUFIFO_H */
