/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.http.api;

import crawlercommons.robots.BaseRobotRules;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.metadata.Nutch;
import org.apache.nutch.net.protocols.ProtocolLogUtil;
import org.apache.nutch.net.protocols.Response;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.protocol.Protocol;
import org.apache.nutch.protocol.ProtocolException;
import org.apache.nutch.protocol.ProtocolOutput;
import org.apache.nutch.protocol.ProtocolStatus;
import org.apache.nutch.protocol.http.api.HttpRobotRulesParser;
import org.apache.nutch.util.DeflateUtils;
import org.apache.nutch.util.GZIPUtils;
import org.apache.nutch.util.MimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpBase
implements Protocol {
    public static final Text RESPONSE_TIME = new Text("_rs_");
    public static final Text COOKIE = new Text("Cookie");
    public static final int BUFFER_SIZE = 8192;
    private static final byte[] EMPTY_CONTENT = new byte[0];
    private HttpRobotRulesParser robots = null;
    private ArrayList<String> userAgentNames = null;
    private Map<String, String> hostCookies = null;
    protected String proxyHost = null;
    protected int proxyPort = 8080;
    protected Proxy.Type proxyType = Proxy.Type.HTTP;
    protected HashMap<String, String> proxyException = new HashMap();
    protected boolean useProxy = false;
    protected int timeout = 10000;
    protected int maxContent = 0x100000;
    protected int maxDuration = 300;
    protected boolean partialAsTruncated = false;
    protected String userAgent = HttpBase.getAgentString("NutchCVS", null, "Nutch", "https://nutch.apache.org/bot.html", "agent@nutch.apache.org");
    protected String acceptLanguage = "en-us,en-gb,en;q=0.7,*;q=0.3";
    protected String acceptCharset = "utf-8,iso-8859-1;q=0.7,*;q=0.7";
    protected String accept = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Logger logger = LOG;
    private Configuration conf = null;
    private ProtocolLogUtil logUtil = new ProtocolLogUtil();
    private MimeUtil mimeTypes = null;
    protected boolean useHttp11 = false;
    protected boolean useHttp2 = false;
    protected boolean responseTime = true;
    protected boolean storeIPAddress = false;
    protected boolean storeHttpRequest = false;
    protected boolean storeHttpHeaders = false;
    protected boolean storeProtocolVersions = false;
    protected long maxCrawlDelay = -1L;
    protected boolean tlsCheckCertificate = false;
    protected Set<String> tlsPreferredProtocols;
    protected Set<String> tlsPreferredCipherSuites;
    protected boolean enableIfModifiedsinceHeader = true;
    protected boolean enableCookieHeader = true;

    public HttpBase() {
        this(null);
    }

    public HttpBase(Logger logger) {
        if (logger != null) {
            this.logger = logger;
        }
        this.robots = new HttpRobotRulesParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConf(Configuration conf) {
        String word;
        Reader reader;
        BufferedReader br;
        this.conf = conf;
        this.proxyHost = conf.get("http.proxy.host");
        this.proxyPort = conf.getInt("http.proxy.port", 8080);
        this.proxyType = Proxy.Type.valueOf(conf.get("http.proxy.type", "HTTP"));
        this.proxyException = HttpBase.arrayToMap(conf.getStrings("http.proxy.exception.list"));
        this.useProxy = this.proxyHost != null && this.proxyHost.length() > 0;
        this.timeout = conf.getInt("http.timeout", 10000);
        this.maxContent = conf.getInt("http.content.limit", 0x100000);
        this.maxDuration = conf.getInt("http.time.limit", -1);
        this.partialAsTruncated = conf.getBoolean("http.partial.truncated", false);
        this.userAgent = HttpBase.getAgentString(conf.get("http.agent.name"), conf.get("http.agent.version"), conf.get("http.agent.description"), conf.get("http.agent.url"), conf.get("http.agent.email"));
        this.acceptLanguage = conf.get("http.accept.language", this.acceptLanguage).trim();
        this.acceptCharset = conf.get("http.accept.charset", this.acceptCharset).trim();
        this.accept = conf.get("http.accept", this.accept).trim();
        this.mimeTypes = new MimeUtil(conf);
        this.useHttp11 = conf.getBoolean("http.useHttp11", true);
        this.useHttp2 = conf.getBoolean("http.useHttp2", false);
        this.tlsCheckCertificate = conf.getBoolean("http.tls.certificates.check", false);
        this.responseTime = conf.getBoolean("http.store.responsetime", true);
        this.storeIPAddress = conf.getBoolean("store.ip.address", false);
        this.storeHttpRequest = conf.getBoolean("store.http.request", false);
        this.storeHttpHeaders = conf.getBoolean("store.http.headers", false);
        this.storeProtocolVersions = conf.getBoolean("store.protocol.versions", false);
        this.enableIfModifiedsinceHeader = conf.getBoolean("http.enable.if.modified.since.header", true);
        this.enableCookieHeader = conf.getBoolean("http.enable.cookie.header", true);
        this.robots.setConf(conf);
        this.logUtil.setConf(conf);
        if (conf.getBoolean("http.agent.rotate", false)) {
            String agentsFile = conf.get("http.agent.rotate.file", "agents.txt");
            br = null;
            try {
                reader = conf.getConfResourceAsReader(agentsFile);
                br = new BufferedReader(reader);
                this.userAgentNames = new ArrayList();
                word = "";
                while ((word = br.readLine()) != null) {
                    if (word.trim().isEmpty()) continue;
                    this.userAgentNames.add(word.trim());
                }
                if (this.userAgentNames.size() == 0) {
                    this.logger.warn("Empty list of user agents in http.agent.rotate.file {}", (Object)agentsFile);
                    this.userAgentNames = null;
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to read http.agent.rotate.file {}: {}", (Object)agentsFile, (Object)StringUtils.stringifyException((Throwable)e));
                this.userAgentNames = null;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (this.userAgentNames == null) {
                this.logger.warn("Falling back to fixed user agent set via property http.agent.name");
            }
        }
        if (this.enableCookieHeader) {
            String cookieFile = conf.get("http.agent.host.cookie.file", "cookies.txt");
            br = null;
            try {
                reader = conf.getConfResourceAsReader(cookieFile);
                br = new BufferedReader(reader);
                this.hostCookies = new HashMap<String, String>();
                word = "";
                while ((word = br.readLine()) != null) {
                    if (word.trim().isEmpty() || word.indexOf("#") != -1) continue;
                    String[] parts = word.split("\t");
                    if (parts.length == 2) {
                        this.hostCookies.put(parts[0], parts[1]);
                        continue;
                    }
                    LOG.warn("Unable to parse cookie file correctly at: {}", (Object)word);
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to read http.agent.host.cookie.file {}: {}", (Object)cookieFile, (Object)StringUtils.stringifyException((Throwable)e));
                this.hostCookies = null;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        String[] protocols = conf.getStrings("http.tls.supported.protocols");
        String[] ciphers = conf.getStrings("http.tls.supported.cipher.suites");
        if (protocols == null) {
            protocols = new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"};
        }
        if (ciphers == null) {
            ciphers = ((SSLSocketFactory)SSLSocketFactory.getDefault()).getDefaultCipherSuites();
        }
        this.tlsPreferredProtocols = new HashSet<String>(Arrays.asList(protocols));
        this.tlsPreferredCipherSuites = new HashSet<String>(Arrays.asList(ciphers));
        this.logConf();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public ProtocolOutput getProtocolOutput(Text url, CrawlDatum datum) {
        String urlString = url.toString();
        try {
            URL u = new URL(urlString);
            long startTime = System.currentTimeMillis();
            Response response = this.getResponse(u, datum, false);
            if (this.responseTime) {
                int elapsedTime = (int)(System.currentTimeMillis() - startTime);
                datum.getMetaData().put((Writable)RESPONSE_TIME, (Writable)new IntWritable(elapsedTime));
            }
            int code = response.getCode();
            datum.getMetaData().put((Writable)Nutch.PROTOCOL_STATUS_CODE_KEY, (Writable)new Text(Integer.toString(code)));
            byte[] content = response.getContent();
            Content c = new Content(u.toString(), u.toString(), content == null ? EMPTY_CONTENT : content, response.getHeader("Content-Type"), response.getHeaders(), this.mimeTypes);
            if (code == 200) {
                return new ProtocolOutput(c);
            }
            if (code >= 300 && code < 400) {
                int protocolStatusCode;
                String location = response.getHeader("Location");
                if (location == null) {
                    location = response.getHeader("location");
                }
                if (location == null) {
                    location = "";
                }
                u = new URL(u, location);
                switch (code) {
                    case 300: {
                        protocolStatusCode = 12;
                        break;
                    }
                    case 301: 
                    case 305: {
                        protocolStatusCode = 12;
                        break;
                    }
                    case 302: 
                    case 303: 
                    case 307: {
                        protocolStatusCode = 13;
                        break;
                    }
                    case 304: {
                        protocolStatusCode = 21;
                        break;
                    }
                    default: {
                        protocolStatusCode = 12;
                    }
                }
                return new ProtocolOutput(c, new ProtocolStatus(protocolStatusCode, (Object)u));
            }
            if (code == 400) {
                this.logger.trace("400 Bad request: {}", (Object)u);
                return new ProtocolOutput(c, new ProtocolStatus(11, (Object)u));
            }
            if (code == 401) {
                this.logger.trace("401 Authentication Required");
                return new ProtocolOutput(c, new ProtocolStatus(17, (Object)("Authentication required: " + urlString)));
            }
            if (code == 404) {
                return new ProtocolOutput(c, new ProtocolStatus(14, (Object)u));
            }
            if (code == 410) {
                return new ProtocolOutput(c, new ProtocolStatus(11, (Object)("Http: " + code + " url=" + String.valueOf(u))));
            }
            return new ProtocolOutput(c, new ProtocolStatus(16, (Object)("Http code=" + code + ", url=" + String.valueOf(u))));
        }
        catch (Throwable e) {
            if (this.logger.isDebugEnabled() || !this.logUtil.logShort(e)) {
                this.logger.error("Failed to get protocol output", e);
            } else {
                this.logger.error("Failed to get protocol output: {}", (Object)e.getClass().getName());
            }
            return new ProtocolOutput(null, new ProtocolStatus(e));
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public boolean useProxy(URL url) {
        return this.useProxy(url.getHost());
    }

    public boolean useProxy(URI uri) {
        return this.useProxy(uri.getHost());
    }

    public boolean useProxy(String host) {
        if (this.useProxy && this.proxyException.containsKey(host)) {
            return false;
        }
        return this.useProxy;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isIfModifiedSinceEnabled() {
        return this.enableIfModifiedsinceHeader;
    }

    public boolean isCookieEnabled() {
        return this.enableCookieHeader;
    }

    public boolean isStoreIPAddress() {
        return this.storeIPAddress;
    }

    public boolean isStoreHttpRequest() {
        return this.storeHttpRequest;
    }

    public boolean isStoreHttpHeaders() {
        return this.storeHttpHeaders;
    }

    public int getMaxContent() {
        return this.maxContent;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public boolean isStorePartialAsTruncated() {
        return this.partialAsTruncated;
    }

    public String getUserAgent() {
        if (this.userAgentNames != null) {
            return this.userAgentNames.get(ThreadLocalRandom.current().nextInt(this.userAgentNames.size()));
        }
        return this.userAgent;
    }

    public String getCookie(URL url) {
        if (this.hostCookies != null) {
            return this.hostCookies.get(url.getHost());
        }
        return null;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public String getAcceptCharset() {
        return this.acceptCharset;
    }

    public String getAccept() {
        return this.accept;
    }

    public boolean getUseHttp11() {
        return this.useHttp11;
    }

    public boolean isTlsCheckCertificates() {
        return this.tlsCheckCertificate;
    }

    public Set<String> getTlsPreferredCipherSuites() {
        return this.tlsPreferredCipherSuites;
    }

    public Set<String> getTlsPreferredProtocols() {
        return this.tlsPreferredProtocols;
    }

    private static String getAgentString(String agentName, String agentVersion, String agentDesc, String agentURL, String agentEmail) {
        if (agentName == null || agentName.trim().isEmpty()) {
            LOG.error("No User-Agent string set (http.agent.name)!");
        }
        StringBuilder buf = new StringBuilder();
        buf.append(agentName);
        if (agentVersion != null && !agentVersion.trim().isEmpty()) {
            buf.append("/");
            buf.append(agentVersion);
        }
        if (agentDesc != null && !agentDesc.isEmpty() || agentEmail != null && !agentEmail.isEmpty() || agentURL != null && !agentURL.isEmpty()) {
            buf.append(" (");
            if (agentDesc != null && !agentDesc.isEmpty()) {
                buf.append(agentDesc);
                if (agentURL != null || agentEmail != null) {
                    buf.append("; ");
                }
            }
            if (agentURL != null && !agentURL.isEmpty()) {
                buf.append(agentURL);
                if (agentEmail != null) {
                    buf.append("; ");
                }
            }
            if (agentEmail != null && !agentEmail.isEmpty()) {
                buf.append(agentEmail);
            }
            buf.append(")");
        }
        return buf.toString();
    }

    protected void logConf() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("http.proxy.host = {}", (Object)this.proxyHost);
            this.logger.info("http.proxy.port = {}", (Object)this.proxyPort);
            this.logger.info("http.proxy.exception.list = {}", (Object)this.useProxy);
            this.logger.info("http.timeout = {}", (Object)this.timeout);
            this.logger.info("http.content.limit = {}", (Object)this.maxContent);
            this.logger.info("http.agent = {}", (Object)this.userAgent);
            this.logger.info("http.accept.language = {}", (Object)this.acceptLanguage);
            this.logger.info("http.accept = {}", (Object)this.accept);
            this.logger.info("http.enable.cookie.header = {}", (Object)this.isCookieEnabled());
        }
    }

    public byte[] processGzipEncoded(byte[] compressed, URL url) throws IOException {
        LOG.trace("uncompressing....");
        if (compressed.length == 0) {
            return compressed;
        }
        byte[] content = this.getMaxContent() >= 0 ? GZIPUtils.unzipBestEffort((byte[])compressed, (int)this.getMaxContent()) : GZIPUtils.unzipBestEffort((byte[])compressed);
        if (content == null) {
            throw new IOException("unzipBestEffort returned null");
        }
        LOG.trace("fetched {} bytes of compressed content (expanded to {} bytes) from {}", new Object[]{compressed.length, content.length, url});
        return content;
    }

    public byte[] processDeflateEncoded(byte[] compressed, URL url) throws IOException {
        if (compressed.length == 0) {
            return compressed;
        }
        LOG.trace("inflating....");
        byte[] content = this.getMaxContent() >= 0 ? DeflateUtils.inflateBestEffort((byte[])compressed, (int)this.getMaxContent()) : DeflateUtils.inflateBestEffort((byte[])compressed);
        if (content == null) {
            throw new IOException("inflateBestEffort returned null");
        }
        LOG.trace("fetched {} bytes of compressed content (expanded to {} bytes) from {}", new Object[]{compressed.length, content.length, url});
        return content;
    }

    protected static void main(HttpBase http, String[] args) throws Exception {
        String url = null;
        String usage = "Usage: Http [-verbose] [-timeout N] url";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-timeout")) {
                http.timeout = Integer.parseInt(args[++i]) * 1000;
                continue;
            }
            if (args[i].equals("-verbose")) continue;
            if (i != args.length - 1) {
                System.err.println(usage);
                System.exit(-1);
                continue;
            }
            url = args[i];
        }
        ProtocolOutput out = http.getProtocolOutput(new Text(url), new CrawlDatum());
        Content content = out.getContent();
        System.out.println("Status: " + String.valueOf(out.getStatus()));
        if (content != null) {
            System.out.println("Content Type: " + content.getContentType());
            System.out.println("Content Length: " + content.getMetadata().get("Content-Length"));
            System.out.println("Content:");
            String text = new String(content.getContent());
            System.out.println(text);
        }
    }

    protected abstract Response getResponse(URL var1, CrawlDatum var2, boolean var3) throws ProtocolException, IOException;

    public BaseRobotRules getRobotRules(Text url, CrawlDatum datum, List<Content> robotsTxtContent) {
        return this.robots.getRobotRulesSet(this, url, robotsTxtContent);
    }

    private static HashMap<String, String> arrayToMap(String[] input) {
        if (input == null || input.length == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        for (int i = 0; i < input.length; ++i) {
            if (input[i].trim().isEmpty()) continue;
            hm.put(input[i], input[i]);
        }
        return hm;
    }
}

