/*
 * Decompiled with CFR 0.152.
 */
package org.archive.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.archive.hadoop.ResourceContext;
import org.archive.hadoop.ResourceInputFormat;
import org.archive.hadoop.ResourceRecordReader;
import org.archive.resource.MetaData;

public class ArchiveMetadataLoader
extends FileInputLoadFunc {
    private static final Logger LOG = Logger.getLogger(ArchiveMetadataLoader.class.getName());
    ResourceRecordReader reader;
    protected TupleFactory mTupleFactory = TupleFactory.getInstance();
    private ArrayList<Object> mProtoTuple = new ArrayList(3);
    private ResourceContext key;
    private MetaData value;

    public InputFormat getInputFormat() throws IOException {
        return new ResourceInputFormat();
    }

    public Tuple getNext() throws IOException {
        boolean next = false;
        try {
            next = this.reader.nextKeyValue();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (!next) {
            return null;
        }
        try {
            this.key = this.reader.getCurrentKey();
            LOG.info(String.format("Loaded key-offset %d\n", this.key.offset));
            this.value = this.reader.getCurrentValue();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        this.mProtoTuple.add(this.key.name);
        this.mProtoTuple.add(this.key.offset);
        this.mProtoTuple.add(this.value.getTopMetaData().toString());
        Tuple t = this.mTupleFactory.newTuple(this.mProtoTuple);
        this.mProtoTuple.clear();
        return t;
    }

    public void prepareToRead(RecordReader reader, PigSplit arg1) throws IOException {
        this.reader = (ResourceRecordReader)reader;
    }

    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }
}

