/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.regex.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.netbeans.modules.java.hints.regex.parser.RegexConstructs;

public class ExampleGenerator {
    private final RegexConstructs.RegEx regEx;
    private Random rnd = new Random();
    private boolean DOT_ALL = false;

    public ExampleGenerator(RegexConstructs.RegEx regEx) {
        this.regEx = regEx;
    }

    public void setDOT_ALL(boolean DOT_ALL) {
        this.DOT_ALL = DOT_ALL;
    }

    public ArrayList<String> generate(int n) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            StringBuilder sb = new StringBuilder();
            this.buildExample(this.regEx, sb);
            result.add(sb.toString());
        }
        return result;
    }

    private void buildExample(RegexConstructs.RegEx regex, StringBuilder sb) {
        if (regex instanceof RegexConstructs.Blank) {
            return;
        }
        if (regex instanceof RegexConstructs.Primitive) {
            sb.append(((RegexConstructs.Primitive)regex).getCh());
            return;
        }
        if (regex instanceof RegexConstructs.Repetition) {
            int nextInt = this.rnd.nextInt(10);
            RegexConstructs.RegEx internal = ((RegexConstructs.Repetition)regex).getInternal();
            for (int i = 0; i < nextInt; ++i) {
                this.buildExample(internal, sb);
            }
            return;
        }
        if (regex instanceof RegexConstructs.OneOrMore) {
            int nextInt = this.rnd.nextInt(10) + 1;
            RegexConstructs.RegEx internal = ((RegexConstructs.OneOrMore)regex).getInternal();
            for (int i = 0; i < nextInt; ++i) {
                this.buildExample(internal, sb);
            }
            return;
        }
        if (regex instanceof RegexConstructs.Group) {
            RegexConstructs.GroupType groupType;
            if (regex instanceof RegexConstructs.SpecialConstructGroup && ((groupType = ((RegexConstructs.SpecialConstructGroup)regex).getGroupType()).isNegative() || groupType.isPositive())) {
                return;
            }
            RegexConstructs.RegEx internal = ((RegexConstructs.Group)regex).getInternal();
            this.buildExample(internal, sb);
            return;
        }
        if (regex instanceof RegexConstructs.Optional) {
            boolean nextBool = this.rnd.nextBoolean();
            RegexConstructs.RegEx internal = ((RegexConstructs.Optional)regex).getInternal();
            if (nextBool) {
                this.buildExample(internal, sb);
            }
            return;
        }
        if (regex instanceof RegexConstructs.GreedyBound) {
            RegexConstructs.RegEx internal = ((RegexConstructs.GreedyBound)regex).getInternal();
            int min = ((RegexConstructs.GreedyBound)regex).getMin();
            boolean maxPresent = ((RegexConstructs.GreedyBound)regex).isMaxPresent();
            int max = ((RegexConstructs.GreedyBound)regex).getMax();
            int nextInt = maxPresent ? this.rnd.nextInt(max - min + 1) + min : this.rnd.nextInt(10) + min;
            for (int i = 0; i < nextInt; ++i) {
                this.buildExample(internal, sb);
            }
            return;
        }
        if (regex instanceof RegexConstructs.AnyChar) {
            int nextInt = this.rnd.nextInt(94) + 32;
            sb.append((char)nextInt);
            return;
        }
        if (regex instanceof RegexConstructs.CharClass) {
            RegexConstructs.CharClass charClass = (RegexConstructs.CharClass)regex;
            List<Character> charClassList = charClass.isNegation() ? charClass.getNegationList() : charClass.getAllChar();
            int n = charClassList.size();
            sb.append(charClassList.get(this.rnd.nextInt(n)));
            return;
        }
        if (regex instanceof RegexConstructs.Range) {
            char from = ((RegexConstructs.Range)regex).getFrom();
            char to = ((RegexConstructs.Range)regex).getTo();
            int length = to - from;
            sb.append((char)(from + this.rnd.nextInt(length + 1)));
            return;
        }
        if (regex instanceof RegexConstructs.Choice) {
            ArrayList<RegexConstructs.RegEx> choices = ((RegexConstructs.Choice)regex).getChoice();
            int n = choices.size();
            this.buildExample(choices.get(this.rnd.nextInt(n)), sb);
            return;
        }
        if (regex instanceof RegexConstructs.Concat) {
            ArrayList<RegexConstructs.RegEx> concatNodes = ((RegexConstructs.Concat)regex).getConcat();
            concatNodes.forEach(nodes -> this.buildExample((RegexConstructs.RegEx)nodes, sb));
        }
    }
}

