/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.classfile;

import java.io.IOException;
import jpt.sun.tools.classfile.Attribute;
import jpt.sun.tools.classfile.ClassReader;
import jpt.sun.tools.classfile.ConstantPool;
import jpt.sun.tools.classfile.ConstantPoolException;

public class ModuleHashes_attribute
extends Attribute {
    public final int algorithm_index;
    public final int hashes_table_length;
    public final Entry[] hashes_table;

    ModuleHashes_attribute(ClassReader cr, int name_index, int length) throws IOException {
        super(name_index, length);
        this.algorithm_index = cr.readUnsignedShort();
        this.hashes_table_length = cr.readUnsignedShort();
        this.hashes_table = new Entry[this.hashes_table_length];
        for (int i = 0; i < this.hashes_table_length; ++i) {
            this.hashes_table[i] = new Entry(cr);
        }
    }

    public ModuleHashes_attribute(ConstantPool constant_pool, int algorithm_index, Entry[] hashes_table) throws ConstantPoolException {
        this(constant_pool.getUTF8Index("ModuleHashes"), algorithm_index, hashes_table);
    }

    public ModuleHashes_attribute(int name_index, int algorithm_index, Entry[] hashes_table) {
        super(name_index, 4 + ModuleHashes_attribute.length(hashes_table));
        this.algorithm_index = algorithm_index;
        this.hashes_table_length = hashes_table.length;
        this.hashes_table = hashes_table;
    }

    @Override
    public <R, D> R accept(Attribute.Visitor<R, D> visitor, D data) {
        return visitor.visitModuleHashes(this, data);
    }

    private static int length(Entry[] hashes_table) {
        int len = 0;
        for (Entry e : hashes_table) {
            len += e.length();
        }
        return len;
    }

    public static class Entry {
        public final int module_name_index;
        public final byte[] hash;

        Entry(ClassReader cr) throws IOException {
            this.module_name_index = cr.readUnsignedShort();
            int hash_length = cr.readUnsignedShort();
            this.hash = new byte[hash_length];
            for (int i = 0; i < hash_length; ++i) {
                this.hash[i] = (byte)cr.readUnsignedByte();
            }
        }

        public int length() {
            return 4 + this.hash.length;
        }
    }
}

