/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package javax.faces.component.html;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;


// Generated from class javax.faces.component.html._HtmlMessages.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class HtmlMessages extends javax.faces.component.UIMessages
{

    static public final String COMPONENT_FAMILY =
        "javax.faces.Messages";
    static public final String COMPONENT_TYPE =
        "javax.faces.HtmlMessages";


    public HtmlMessages()
    {
        setRendererType("javax.faces.Messages");
    }

    @Override    
    public String getFamily()
    {
        return COMPONENT_FAMILY;
    }
    

    // Property: layout
    private String _layout;
    
    public String getLayout()
    {
        if (_layout != null)
        {
            return _layout;
        }
        ValueExpression vb = getValueExpression("layout");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return "list"; 
    }

    public void setLayout(String layout)
    {
        this._layout = layout;
    }
    // Property: style
    private String _style;
    
    public String getStyle()
    {
        if (_style != null)
        {
            return _style;
        }
        ValueExpression vb = getValueExpression("style");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String style)
    {
        this._style = style;
    }
    // Property: styleClass
    private String _styleClass;
    
    public String getStyleClass()
    {
        if (_styleClass != null)
        {
            return _styleClass;
        }
        ValueExpression vb = getValueExpression("styleClass");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String styleClass)
    {
        this._styleClass = styleClass;
    }
    // Property: errorClass
    private String _errorClass;
    
    public String getErrorClass()
    {
        if (_errorClass != null)
        {
            return _errorClass;
        }
        ValueExpression vb = getValueExpression("errorClass");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setErrorClass(String errorClass)
    {
        this._errorClass = errorClass;
    }
    // Property: errorStyle
    private String _errorStyle;
    
    public String getErrorStyle()
    {
        if (_errorStyle != null)
        {
            return _errorStyle;
        }
        ValueExpression vb = getValueExpression("errorStyle");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setErrorStyle(String errorStyle)
    {
        this._errorStyle = errorStyle;
    }
    // Property: fatalClass
    private String _fatalClass;
    
    public String getFatalClass()
    {
        if (_fatalClass != null)
        {
            return _fatalClass;
        }
        ValueExpression vb = getValueExpression("fatalClass");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setFatalClass(String fatalClass)
    {
        this._fatalClass = fatalClass;
    }
    // Property: fatalStyle
    private String _fatalStyle;
    
    public String getFatalStyle()
    {
        if (_fatalStyle != null)
        {
            return _fatalStyle;
        }
        ValueExpression vb = getValueExpression("fatalStyle");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setFatalStyle(String fatalStyle)
    {
        this._fatalStyle = fatalStyle;
    }
    // Property: infoClass
    private String _infoClass;
    
    public String getInfoClass()
    {
        if (_infoClass != null)
        {
            return _infoClass;
        }
        ValueExpression vb = getValueExpression("infoClass");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setInfoClass(String infoClass)
    {
        this._infoClass = infoClass;
    }
    // Property: infoStyle
    private String _infoStyle;
    
    public String getInfoStyle()
    {
        if (_infoStyle != null)
        {
            return _infoStyle;
        }
        ValueExpression vb = getValueExpression("infoStyle");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setInfoStyle(String infoStyle)
    {
        this._infoStyle = infoStyle;
    }
    // Property: tooltip
    private boolean _tooltip;
    
    private boolean _tooltipSet;
    
    public boolean isTooltip()
    {
        if (_tooltipSet)
        {
            return _tooltip;
        }
        ValueExpression vb = getValueExpression("tooltip");
        if (vb != null)
        {
            return ((Boolean) vb.getValue(getFacesContext().getELContext())).booleanValue();
        }
        return false; 
    }

    public void setTooltip(boolean tooltip)
    {
        this._tooltip = tooltip;
        this._tooltipSet = true;        
    }
    // Property: warnClass
    private String _warnClass;
    
    public String getWarnClass()
    {
        if (_warnClass != null)
        {
            return _warnClass;
        }
        ValueExpression vb = getValueExpression("warnClass");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setWarnClass(String warnClass)
    {
        this._warnClass = warnClass;
    }
    // Property: warnStyle
    private String _warnStyle;
    
    public String getWarnStyle()
    {
        if (_warnStyle != null)
        {
            return _warnStyle;
        }
        ValueExpression vb = getValueExpression("warnStyle");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setWarnStyle(String warnStyle)
    {
        this._warnStyle = warnStyle;
    }
    // Property: dir
    private String _dir;
    
    public String getDir()
    {
        if (_dir != null)
        {
            return _dir;
        }
        ValueExpression vb = getValueExpression("dir");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setDir(String dir)
    {
        this._dir = dir;
    }
    // Property: lang
    private String _lang;
    
    public String getLang()
    {
        if (_lang != null)
        {
            return _lang;
        }
        ValueExpression vb = getValueExpression("lang");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setLang(String lang)
    {
        this._lang = lang;
    }
    // Property: title
    private String _title;
    
    public String getTitle()
    {
        if (_title != null)
        {
            return _title;
        }
        ValueExpression vb = getValueExpression("title");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setTitle(String title)
    {
        this._title = title;
    }

    @Override
    public Object saveState(FacesContext facesContext)
    {
        Object[] values = new Object[17];
        values[0] = super.saveState(facesContext);
        values[1] = _layout;
        values[2] = _style;
        values[3] = _styleClass;
        values[4] = _errorClass;
        values[5] = _errorStyle;
        values[6] = _fatalClass;
        values[7] = _fatalStyle;
        values[8] = _infoClass;
        values[9] = _infoStyle;
        values[10] = Boolean.valueOf(_tooltip);
        values[11] = Boolean.valueOf(_tooltipSet);
        values[12] = _warnClass;
        values[13] = _warnStyle;
        values[14] = _dir;
        values[15] = _lang;
        values[16] = _title;
        return values; 
    }

    @Override
    public void restoreState(FacesContext facesContext, Object state)
    {
        Object[] values = (Object[])state;
        super.restoreState(facesContext,values[0]);
        _layout = (java.lang.String) values[1];
        _style = (java.lang.String) values[2];
        _styleClass = (java.lang.String) values[3];
        _errorClass = (java.lang.String) values[4];
        _errorStyle = (java.lang.String) values[5];
        _fatalClass = (java.lang.String) values[6];
        _fatalStyle = (java.lang.String) values[7];
        _infoClass = (java.lang.String) values[8];
        _infoStyle = (java.lang.String) values[9];
        _tooltip = ((Boolean) values[10]).booleanValue();
        _tooltipSet = ((Boolean) values[11]).booleanValue();
        _warnClass = (java.lang.String) values[12];
        _warnStyle = (java.lang.String) values[13];
        _dir = (java.lang.String) values[14];
        _lang = (java.lang.String) values[15];
        _title = (java.lang.String) values[16];
    }
}
