/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.facelets.tag;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.MethodExpression;
import javax.faces.el.MethodBinding;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import org.apache.myfaces.custom.facelets.tag.LegacyMethodBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodRule
extends MetaRule {
    private final String methodName;
    private final String propertyName;
    private final Class<?> returnTypeClass;
    private final Class<?>[] params;

    public MethodRule(String methodName, Class<?> returnTypeClass, Class<?>[] params) {
        this.methodName = methodName;
        this.propertyName = methodName;
        this.returnTypeClass = returnTypeClass;
        this.params = params;
    }

    public MethodRule(String methodName, String propertyName, Class<?> returnTypeClass, Class<?>[] params) {
        this.methodName = methodName;
        this.propertyName = propertyName;
        this.returnTypeClass = returnTypeClass;
        this.params = params;
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method method;
        if (!name.equals(this.methodName)) {
            return null;
        }
        if (MethodExpression.class.equals((Object)meta.getPropertyType(this.propertyName))) {
            Method method2 = meta.getWriteMethod(this.propertyName);
            if (method2 != null) {
                return new MethodExpressionMetadata(method2, attribute, this.returnTypeClass, this.params);
            }
        } else if (MethodBinding.class.equals((Object)meta.getPropertyType(this.propertyName)) && (method = meta.getWriteMethod(this.propertyName)) != null) {
            return new MethodBindingMetadata(method, attribute, this.returnTypeClass, this.params);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodExpressionMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Class<?>[] _paramList;
        private Class<?> _returnType;

        public MethodExpressionMetadata(Method method, TagAttribute attribute, Class<?> returnType, Class<?>[] paramList) {
            this._method = method;
            this._attribute = attribute;
            this._paramList = paramList;
            this._returnType = returnType;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            MethodExpression expr = this._attribute.getMethodExpression(ctx, this._returnType, (Class[])this._paramList);
            try {
                this._method.invoke(instance, expr);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }
    }

    private class MethodBindingMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Class[] _paramList;
        private Class _returnType;

        public MethodBindingMetadata(Method method, TagAttribute attribute, Class returnType, Class[] paramList) {
            this._method = method;
            this._attribute = attribute;
            this._paramList = paramList;
            this._returnType = returnType;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            MethodExpression expr = this._attribute.getMethodExpression(ctx, this._returnType, this._paramList);
            try {
                this._method.invoke(instance, new LegacyMethodBinding(expr));
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }
    }
}

