/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import org.apache.myfaces.test.mock.MockEnumeration;

public class MockPortletRequest
implements PortletRequest {
    private Map attributes = new HashMap();
    private String contextPath = null;
    private Locale locale = null;
    private Map parameters = new HashMap();
    private Principal principal = null;
    private PortletSession session = null;

    public MockPortletRequest() {
    }

    public MockPortletRequest(PortletSession session) {
        this.session = session;
    }

    public void addParameter(String name, String value) {
        String[] values = (String[])this.parameters.get(name);
        if (values == null) {
            String[] results = new String[]{value};
            this.parameters.put(name, results);
            return;
        }
        String[] results = new String[values.length + 1];
        System.arraycopy(values, 0, results, 0, values.length);
        results[values.length] = value;
        this.parameters.put(name, results);
    }

    public void setPortletSession(PortletSession session) {
        this.session = session;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setUserPrincipal(Principal principal) {
        this.principal = principal;
    }

    public String getAuthType() {
        throw new UnsupportedOperationException();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new MockEnumeration(this.attributes.keySet().iterator());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getLocales() {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameters.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public Enumeration getParameterNames() {
        return new MockEnumeration(this.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public PortalContext getPortalContext() {
        throw new UnsupportedOperationException();
    }

    public PortletMode getPortletMode() {
        throw new UnsupportedOperationException();
    }

    public PortletSession getPortletSession() {
        return this.getPortletSession(true);
    }

    public PortletSession getPortletSession(boolean create) {
        if (create && this.session == null) {
            throw new UnsupportedOperationException();
        }
        return this.session;
    }

    public PortletPreferences getPreferences() {
        throw new UnsupportedOperationException();
    }

    public Enumeration getProperties(String arg0) {
        throw new UnsupportedOperationException();
    }

    public String getProperty(String arg0) {
        throw new UnsupportedOperationException();
    }

    public Enumeration getPropertyNames() {
        throw new UnsupportedOperationException();
    }

    public String getRemoteUser() {
        if (this.principal != null) {
            return this.principal.getName();
        }
        return null;
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException();
    }

    public String getResponseContentType() {
        throw new UnsupportedOperationException();
    }

    public Enumeration getResponseContentTypes() {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        return "localhost";
    }

    public int getServerPort() {
        return 8080;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public WindowState getWindowState() {
        throw new UnsupportedOperationException();
    }

    public boolean isPortletModeAllowed(PortletMode arg0) {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String arg0) {
        throw new UnsupportedOperationException();
    }

    public boolean isWindowStateAllowed(WindowState arg0) {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        this.attributes.put(name, value);
    }
}

