/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.renderkit;

import java.util.Iterator;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.myfaces.extensions.validator.ExtValInformation;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.factory.FactoryNames;
import org.apache.myfaces.extensions.validator.core.renderkit.AbstractRenderKitWrapperFactory;
import org.apache.myfaces.extensions.validator.core.renderkit.DefaultRenderKitWrapperFactory;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class ExtValRenderKitFactory
extends RenderKitFactory {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private RenderKitFactory wrapped;
    private AbstractRenderKitWrapperFactory defaultRenderKitWrapperFactory;
    private Boolean isDeactivated;

    public ExtValRenderKitFactory(RenderKitFactory renderKitFactory) {
        this.wrapped = renderKitFactory;
        this.logger.fine(((Object)((Object)this)).getClass().getName() + " instantiated");
    }

    public void addRenderKit(String s, RenderKit renderKit) {
        this.wrapped.addRenderKit(s, renderKit);
    }

    public RenderKit getRenderKit(FacesContext facesContext, String s) {
        RenderKit renderKit = this.wrapped.getRenderKit(facesContext, s);
        if (renderKit == null) {
            return null;
        }
        this.tryToInitDefaultRenderKitWrapperFactory();
        this.checkRenderKitFactoryDeactivation();
        if (this.isDeactivated.booleanValue()) {
            return renderKit;
        }
        if (!this.defaultRenderKitWrapperFactory.isApplicationInitialized()) {
            return this.defaultRenderKitWrapperFactory.createWrapper(renderKit);
        }
        return this.tryToCreateWrapperWithWrapperFactory(renderKit);
    }

    private void checkRenderKitFactoryDeactivation() {
        if (this.isDeactivated == null) {
            if (ExtValUtils.isExtValDeactivated()) {
                this.isDeactivated = true;
                return;
            }
            this.isDeactivated = this.defaultRenderKitWrapperFactory.isApplicationInitialized() ? Boolean.valueOf(this.isRenderKitFactoryDeactivated()) : Boolean.valueOf(this.isRenderKitFactoryDeactivatedViaVMParameter());
        }
    }

    private synchronized void tryToInitDefaultRenderKitWrapperFactory() {
        if (this.defaultRenderKitWrapperFactory == null) {
            Object customFactory = ClassUtils.tryToInstantiateClassForName(ExtValInformation.EXTENSIONS_VALIDATOR_BASE_PACKAGE_NAME + ".custom.RenderKitWrapperFactory");
            this.defaultRenderKitWrapperFactory = customFactory instanceof AbstractRenderKitWrapperFactory ? (AbstractRenderKitWrapperFactory)customFactory : new DefaultRenderKitWrapperFactory();
        }
    }

    private RenderKit tryToCreateWrapperWithWrapperFactory(RenderKit renderKit) {
        AbstractRenderKitWrapperFactory wrapperFactory = ExtValContext.getContext().getFactoryFinder().getFactory(FactoryNames.RENDERKIT_WRAPPER_FACTORY, AbstractRenderKitWrapperFactory.class);
        if (wrapperFactory.isDeactivated()) {
            return renderKit;
        }
        return wrapperFactory.create(renderKit);
    }

    public Iterator<String> getRenderKitIds() {
        return this.wrapped.getRenderKitIds();
    }

    private boolean isRenderKitFactoryDeactivated() {
        return ExtValCoreConfiguration.get().deactivateRenderKitFactory();
    }

    private boolean isRenderKitFactoryDeactivatedViaVMParameter() {
        return "true".equalsIgnoreCase(System.getProperty(ExtValInformation.EXTENSIONS_VALIDATOR_BASE_PACKAGE_NAME + ".DEACTIVATE_RENDER_KIT_FACTORY", "false"));
    }
}

