/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.validator;

import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.myfaces.core.api.shared.MessageUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class RegexValidator
implements Validator,
PartialStateHolder {
    public static final String VALIDATOR_ID = "jakarta.faces.RegularExpression";
    public static final String PATTERN_NOT_SET_MESSAGE_ID = "jakarta.faces.validator.RegexValidator.PATTERN_NOT_SET";
    public static final String NOT_MATCHED_MESSAGE_ID = "jakarta.faces.validator.RegexValidator.NOT_MATCHED";
    public static final String MATCH_EXCEPTION_MESSAGE_ID = "jakarta.faces.validator.RegexValidator.MATCH_EXCEPTION";
    private static final String EMPTY_STRING = "";
    private String pattern;
    private boolean _transient = false;
    private boolean _initialStateMarked = false;

    public void validate(FacesContext context, UIComponent component, Object value) {
        Pattern thePattern;
        Assert.notNull(context, "context");
        Assert.notNull(component, "component");
        if (value == null) {
            return;
        }
        if (!(value instanceof CharSequence)) {
            Object[] args = new Object[]{value, MessageUtils.getLabel(context, component)};
            throw new ValidatorException(MessageUtils.getErrorMessage(context, "jakarta.faces.converter.STRING", args));
        }
        CharSequence charSequence = (CharSequence)value;
        if (this.pattern == null || this.pattern.equals(EMPTY_STRING)) {
            throw new ValidatorException(MessageUtils.getErrorMessage(context, PATTERN_NOT_SET_MESSAGE_ID, null));
        }
        try {
            thePattern = Pattern.compile(this.pattern);
        }
        catch (PatternSyntaxException pse) {
            throw new ValidatorException(MessageUtils.getErrorMessage(context, MATCH_EXCEPTION_MESSAGE_ID, null));
        }
        if (!thePattern.matcher(charSequence).matches()) {
            Object[] args = new Object[]{thePattern, MessageUtils.getLabel(context, component)};
            throw new ValidatorException(MessageUtils.getErrorMessage(context, NOT_MATCHED_MESSAGE_ID, args));
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        Assert.notNull(context, "context");
        if (!this.initialStateMarked()) {
            return this.pattern;
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Assert.notNull(context, "context");
        if (state != null) {
            this.pattern = (String)state;
        }
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public void setTransient(boolean isTransient) {
        this._transient = isTransient;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.clearInitialState();
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }

    private Boolean isDisabled() {
        return null;
    }

    private String getFor() {
        return null;
    }
}

