/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.ValueHolderAttachedObjectHandler;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.ConverterHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRuleset;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandlerDelegate;
import java.io.IOException;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.MetaRulesetImpl;

public class ConverterTagHandlerDelegate
extends TagHandlerDelegate
implements ValueHolderAttachedObjectHandler {
    private ConverterHandler _delegate;

    public ConverterTagHandlerDelegate(ConverterHandler delegate) {
        this._delegate = delegate;
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (parent instanceof ValueHolder) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            if (this.getFor() == null) {
                throw new TagException(this._delegate.getTag(), "is nested inside a composite component but does not have a for attribute.");
            }
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
            mctx.addAttachedObjectHandler(parent, (AttachedObjectHandler)this._delegate);
        } else {
            throw new TagException(this._delegate.getTag(), "Parent not composite component or an instance of ValueHolder: " + parent);
        }
    }

    protected Converter createConverter(FaceletContext ctx) {
        if (this._delegate.getConverterId(ctx) == null) {
            throw new TagException(this._delegate.getTag(), "Default behavior invoked of requiring a converter-id passed in the constructor, must override ConvertHandler(ConverterConfig)");
        }
        return ctx.getFacesContext().getApplication().createConverter(this._delegate.getConverterId(ctx));
    }

    public MetaRuleset createMetaRuleset(Class type) {
        return new MetaRulesetImpl(this._delegate.getTag(), type).ignore("binding").ignore("for");
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        ValueHolder vh = (ValueHolder)parent;
        ValueExpression ve = null;
        Converter c = null;
        if (this._delegate.getBinding() != null) {
            ve = this._delegate.getBinding().getValueExpression(faceletContext, Converter.class);
            c = (Converter)ve.getValue((ELContext)faceletContext);
        }
        if (c == null) {
            c = this.createConverter(faceletContext);
            if (ve != null) {
                ve.setValue((ELContext)faceletContext, (Object)c);
            }
        }
        if (c == null) {
            throw new TagException(this._delegate.getTag(), "No Converter was created");
        }
        this._delegate.setAttributes(faceletContext, (Object)c);
        vh.setConverter(c);
        Object lv = vh.getLocalValue();
        FacesContext faces = faceletContext.getFacesContext();
        if (lv instanceof String) {
            vh.setValue(c.getAsObject(faces, parent, (String)lv));
        }
    }

    public String getFor() {
        TagAttribute forAttribute = this._delegate.getTagAttribute("for");
        if (forAttribute == null) {
            return null;
        }
        return forAttribute.getValue();
    }
}

