/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import org.apache.myfaces.shared.resource.ResourceImpl;
import org.apache.myfaces.shared.util.io.DynamicPushbackInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueExpressionFilterInputStream
extends InputStream {
    private PushbackInputStream delegate;
    private String libraryName;
    private String resourceName;

    public ValueExpressionFilterInputStream(InputStream in, String libraryName, String resourceName) {
        this.delegate = new DynamicPushbackInputStream(in, 300);
    }

    @Override
    public int read() throws IOException {
        int c1 = this.delegate.read();
        if (c1 == -1) {
            return -1;
        }
        if ((char)c1 == '#') {
            int c2 = this.delegate.read();
            if (c2 == -1) {
                return -1;
            }
            if ((char)c2 == '{') {
                ArrayList<Integer> expressionList = new ArrayList<Integer>();
                int c3 = this.delegate.read();
                while (c3 != -1 && (char)c3 != '}') {
                    expressionList.add(c3);
                    c3 = this.delegate.read();
                }
                if (c3 == -1) {
                    for (int i = 0; i < expressionList.size(); ++i) {
                        this.delegate.unread((Integer)expressionList.get(i));
                    }
                    this.delegate.unread(c2);
                    return c1;
                }
                FacesContext context = FacesContext.getCurrentInstance();
                ELContext elContext = context.getELContext();
                try {
                    ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(elContext, "#{" + this.convertToExpression(expressionList) + "}", String.class);
                    String value = (String)ve.getValue(elContext);
                    for (int i = value.length() - 1; i >= 0; --i) {
                        this.delegate.unread(value.charAt(i));
                    }
                }
                catch (ELException e) {
                    ExceptionQueuedEventContext equecontext = new ExceptionQueuedEventContext(context, e, null);
                    context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, equecontext);
                    Logger log = Logger.getLogger(ResourceImpl.class.getName());
                    if (log.isLoggable(Level.SEVERE)) {
                        log.severe("Cannot evaluate EL expression " + this.convertToExpression(expressionList) + " in resource " + (this.libraryName == null ? "" : this.libraryName) + ":" + (this.resourceName == null ? "" : this.resourceName));
                    }
                    this.delegate.unread(c3);
                    for (int i = expressionList.size() - 1; i >= 0; --i) {
                        this.delegate.unread((Integer)expressionList.get(i));
                    }
                    this.delegate.unread(c2);
                    return c1;
                }
                return this.delegate.read();
            }
            this.delegate.unread(c2);
            return c1;
        }
        return c1;
    }

    private String convertToExpression(List<Integer> expressionList) {
        char[] exprArray = new char[expressionList.size()];
        for (int i = 0; i < expressionList.size(); ++i) {
            exprArray[i] = (char)expressionList.get(i).intValue();
        }
        return String.valueOf(exprArray);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

