/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git.pgm;

import java.util.function.Supplier;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.git.AbstractGitCommandFactory;
import org.apache.sshd.git.GitLocationResolver;
import org.apache.sshd.git.pack.GitPackCommandFactory;
import org.apache.sshd.git.pgm.GitPgmCommand;
import org.apache.sshd.server.command.CommandFactory;

public class GitPgmCommandFactory
extends AbstractGitCommandFactory {
    public static final String GIT_FACTORY_NAME = "git-pgm";
    public static final String GIT_COMMAND_PREFIX = "git ";

    public GitPgmCommandFactory() {
        this(null);
    }

    public GitPgmCommandFactory(GitLocationResolver resolver) {
        super(GIT_FACTORY_NAME, GIT_COMMAND_PREFIX);
        this.withGitLocationResolver(resolver);
    }

    @Override
    public GitPgmCommandFactory withDelegate(CommandFactory delegate) {
        return (GitPgmCommandFactory)super.withDelegate(delegate);
    }

    @Override
    public GitPgmCommandFactory withGitLocationResolver(GitLocationResolver rootDirResolver) {
        return (GitPgmCommandFactory)super.withGitLocationResolver(rootDirResolver);
    }

    @Override
    public GitPackCommandFactory withExecutorServiceProvider(Supplier<? extends CloseableExecutorService> provider) {
        return (GitPackCommandFactory)super.withExecutorServiceProvider(provider);
    }

    @Override
    public GitPgmCommand createGitCommand(String command) {
        String rawCommand = command.substring(GIT_COMMAND_PREFIX.length());
        return new GitPgmCommand(this.getGitLocationResolver(), rawCommand, this.resolveExecutorService(command));
    }
}

