/*
 * Decompiled with CFR 0.152.
 */
package org.tullmann.taglets;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.tullmann.taglets.ListTag;
import org.tullmann.taglets.TagPrefs;

public class ReviewedBy
extends ListTag {
    private static final String UIDS = "review.uids";
    private static final String IN_DATEFORMAT = "review.date.format";
    private static final String SHOW_COMPLETED = "show.completed";
    private static final String SHOW_COMPLETED_SINCE = "show.completed.since";
    private static final String SHOW_MISSING = "show.missing";
    private static final String OUT_DATEFORMAT = "html.date.format";
    private final HashSet allUIDs = new HashSet();
    private HashSet missingIDs;
    private final Date completedSince;
    private final boolean showCompleted;
    private final boolean showMissing;

    public static void register(Map map) {
        ListTag.register(map, new ReviewedBy());
    }

    protected void startingTags() {
        this.missingIDs = (HashSet)this.allUIDs.clone();
    }

    protected void endingTags(StringBuffer stringBuffer) {
        if (this.showMissing) {
            Iterator iterator = this.missingIDs.iterator();
            boolean bl = false;
            if (iterator.hasNext()) {
                stringBuffer.append("<dt><b>");
                super.formatText(stringBuffer, "Missing Reviews:", "html.missing.header");
                stringBuffer.append("</b></dt>\n").append("<dd>\n");
                bl = true;
            }
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            if (bl) {
                stringBuffer.append("</dd>\n");
            }
        }
        this.missingIDs = null;
    }

    protected void forceCustomDefaultPrefs(TagPrefs tagPrefs) {
        super.forceColorPrefs(tagPrefs, "html.missing.header");
        tagPrefs.forcePref(UIDS, "-");
        tagPrefs.forcePref(IN_DATEFORMAT, "yy/MM/dd");
        tagPrefs.forcePref(OUT_DATEFORMAT, "MMMM d, yyyy");
        tagPrefs.forcePref(SHOW_COMPLETED_SINCE, "-");
        tagPrefs.forcePref(SHOW_COMPLETED, "true");
        tagPrefs.forcePref(SHOW_MISSING, "true");
    }

    protected void emitCustomHeader(StringBuffer stringBuffer, boolean bl) {
        if (!bl) {
            stringBuffer.append("<table>\n");
        }
        if (this.showCompleted) {
            stringBuffer.append("<tr>").append("<th>User</th>").append("<th>Date</th>").append("<th>Comment</th>").append("</tr>").append("\n");
        }
    }

    private final void emitReviewEntry(StringBuffer stringBuffer, String string, String string2, String string3) {
        stringBuffer.append("  <td><code>");
        super.formatText(stringBuffer, string, "text");
        stringBuffer.append("</code></td>\n").append("  <td><font size=\"-1\">");
        super.formatText(stringBuffer, string2, "text");
        stringBuffer.append("</font></td>\n").append("  <td>");
        super.formatText(stringBuffer, string3, "text");
        stringBuffer.append("</td>\n");
    }

    protected void emitCustomFooter(StringBuffer stringBuffer, boolean bl) {
        if (!bl) {
            stringBuffer.append("</table>\n");
        }
    }

    String formatDate(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.tagPrefs.getPref(IN_DATEFORMAT));
            Date date = simpleDateFormat.parse(string);
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(this.tagPrefs.getPref(OUT_DATEFORMAT));
            return simpleDateFormat2.format(date);
        }
        catch (ParseException parseException) {
            return string;
        }
    }

    protected void parseTagText(StringBuffer stringBuffer, String string, boolean bl) {
        String[] stringArray = string.split("\\s+", 3);
        String[] stringArray2 = new String[]{stringArray.length > 0 ? stringArray[0] : "UNKNOWN", stringArray.length > 1 ? this.formatDate(stringArray[1]) : "N/A", stringArray.length > 2 ? stringArray[2] : ""};
        if (this.missingIDs.contains(stringArray2[0])) {
            this.missingIDs.remove(stringArray2[0]);
        } else {
            System.err.println("WARNING(" + this.tagPrefs.prefix() + ") unexpected id: " + stringArray2[0]);
        }
        if (this.showCompleted) {
            this.emitReviewEntry(stringBuffer, stringArray2[0], stringArray2[1], stringArray2[2]);
        }
    }

    public boolean isInlineTag() {
        return false;
    }

    public boolean inField() {
        return false;
    }

    public boolean inConstructor() {
        return false;
    }

    public boolean inMethod() {
        return false;
    }

    public boolean inType() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inOverview() {
        return true;
    }

    public ReviewedBy() {
        this("default");
    }

    public ReviewedBy(String string) {
        super("reviewedby", "reviewedby." + string, "Reviewed By:", ListTag.TABLE_LIST);
        Object object;
        String string2 = this.tagPrefs.getPref(UIDS);
        if (!string2.equals("-")) {
            object = string2.split("\\s*,\\s*");
            int n = 0;
            while (n < ((String[])object).length) {
                this.allUIDs.add(object[n]);
                ++n;
            }
        }
        this.showCompleted = Boolean.valueOf(this.tagPrefs.getPref(SHOW_COMPLETED));
        this.showMissing = Boolean.valueOf(this.tagPrefs.getPref(SHOW_MISSING));
        object = this.tagPrefs.getPref(SHOW_COMPLETED_SINCE);
        if (((String)object).equals(TagPrefs.PREF_NOVALUE)) {
            this.completedSince = null;
        } else {
            Date date = null;
            try {
                date = DateFormat.getDateInstance().parse((String)object);
            }
            catch (ParseException parseException) {
                System.err.println("WARNING(" + this.tagPrefs.prefix() + ") " + "Cannot parse date string" + (String)object);
            }
            this.completedSince = date;
        }
    }
}

