/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeUtility;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.BoundaryDelimitedStream;
import org.apache.axis.attachments.IncomingAttachmentStreams;
import org.apache.axis.utils.Messages;

public final class MultipartAttachmentStreams
extends IncomingAttachmentStreams {
    private BoundaryDelimitedStream _delimitedStream = null;
    private Iterator _attachmentParts = null;

    public MultipartAttachmentStreams(BoundaryDelimitedStream delimitedStream) throws AxisFault {
        this(delimitedStream, null);
    }

    public MultipartAttachmentStreams(BoundaryDelimitedStream delimitedStream, Collection priorParts) throws AxisFault {
        if (delimitedStream == null) {
            throw new AxisFault(Messages.getMessage("nullDelimitedStream"));
        }
        this._delimitedStream = delimitedStream;
        if (priorParts != null) {
            this.setAttachmentsPriorToSoapPart(priorParts.iterator());
        }
    }

    public void setAttachmentsPriorToSoapPart(Iterator iterator) {
        this._attachmentParts = iterator;
    }

    public IncomingAttachmentStreams.IncomingAttachmentInputStream getNextStream() throws AxisFault {
        IncomingAttachmentStreams.IncomingAttachmentInputStream stream;
        if (!this.isReadyToGetNextStream()) {
            throw new IllegalStateException(Messages.getMessage("nextStreamNotReady"));
        }
        if (this._attachmentParts != null && this._attachmentParts.hasNext()) {
            AttachmentPart part = (AttachmentPart)this._attachmentParts.next();
            try {
                stream = new IncomingAttachmentStreams.IncomingAttachmentInputStream(part.getDataHandler().getInputStream());
            }
            catch (IOException e) {
                throw new AxisFault(Messages.getMessage("failedToGetAttachmentPartStream"), e);
            }
            catch (SOAPException e) {
                throw new AxisFault(Messages.getMessage("failedToGetAttachmentPartStream"), e);
            }
            stream.addHeader("Content-Id", part.getContentId());
            stream.addHeader("Content-Location", part.getContentLocation());
            stream.addHeader("Content-Type", part.getContentType());
        } else {
            InternetHeaders headers;
            try {
                this._delimitedStream = this._delimitedStream.getNextStream();
                if (this._delimitedStream == null) {
                    return null;
                }
                headers = new InternetHeaders((InputStream)this._delimitedStream);
                String delimiter = null;
                String encoding = headers.getHeader("Content-Transfer-Encoding", delimiter);
                if (encoding != null && encoding.length() > 0) {
                    encoding = encoding.trim();
                    stream = new IncomingAttachmentStreams.IncomingAttachmentInputStream(MimeUtility.decode((InputStream)this._delimitedStream, (String)encoding));
                    stream.addHeader("Content-Transfer-Encoding", encoding);
                } else {
                    stream = new IncomingAttachmentStreams.IncomingAttachmentInputStream(this._delimitedStream);
                }
            }
            catch (IOException e) {
                throw new AxisFault(Messages.getMessage("failedToGetDelimitedAttachmentStream"), e);
            }
            catch (MessagingException e) {
                throw new AxisFault(Messages.getMessage("failedToGetDelimitedAttachmentStream"), e);
            }
            Enumeration e = headers.getAllHeaders();
            while (e != null && e.hasMoreElements()) {
                Header header = (Header)e.nextElement();
                String name = header.getName();
                String value = header.getValue();
                if ("Content-Id".equals(name) || "Content-Type".equals(name) || "Content-Location".equals(name)) {
                    value = value.trim();
                    if (("Content-Id".equals(name) || "Content-Location".equals(name)) && (name.indexOf(62) > 0 || name.indexOf(60) > 0)) {
                        value = new StringTokenizer(value, "<>").nextToken();
                    }
                }
                stream.addHeader(name, value);
            }
        }
        this.setReadyToGetNextStream(false);
        return stream;
    }
}

