/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.kafka;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.core.common.Base64;

public class KafkaMessage {
    private final String[] acls = null;
    private final String[] denyAcls = null;
    private final String[] shareAcls = null;
    private final String[] shareDenyAcls = null;
    private final String[] parentAcls = null;
    private final String[] parentDenyAcls = null;
    private InputStream inputStream = null;

    public byte[] createJSON(RepositoryDocument document) {
        String finalString = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.inputStream = document.getBinaryStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            pw.print("{");
            Iterator i = document.getFields();
            boolean needComma = false;
            while (i.hasNext()) {
                String fieldName = (String)i.next();
                String[] fieldValues = document.getFieldAsStrings(fieldName);
                needComma = KafkaMessage.writeField(pw, needComma, fieldName, fieldValues);
            }
            needComma = KafkaMessage.writeACLs(pw, needComma, "document", this.acls, this.denyAcls);
            needComma = KafkaMessage.writeACLs(pw, needComma, "share", this.shareAcls, this.shareDenyAcls);
            needComma = KafkaMessage.writeACLs(pw, needComma, "parent", this.parentAcls, this.parentDenyAcls);
            if (this.inputStream != null) {
                String fileName;
                if (needComma) {
                    pw.print(",");
                }
                pw.print("\"file\" : {");
                String contentType = document.getMimeType();
                if (contentType != null) {
                    pw.print("\"_content_type\" : " + KafkaMessage.jsonStringEscape(contentType) + ",");
                }
                if ((fileName = document.getFileName()) != null) {
                    pw.print("\"_name\" : " + KafkaMessage.jsonStringEscape(fileName) + ",");
                }
                pw.print(" \"_content\" : \"");
                Base64 base64 = new Base64();
                base64.encodeStream(this.inputStream, (Writer)pw);
                pw.print("\"}");
            }
            pw.print("}");
            pw.flush();
            IOUtils.closeQuietly((Writer)pw);
            finalString = new String(out.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    protected static boolean writeField(PrintWriter pw, boolean needComma, String fieldName, String[] fieldValues) throws IOException {
        if (fieldValues == null) {
            return needComma;
        }
        if (fieldValues.length == 1) {
            if (needComma) {
                pw.print(",");
            }
            pw.print(KafkaMessage.jsonStringEscape(fieldName) + " : " + KafkaMessage.jsonStringEscape(fieldValues[0]));
            needComma = true;
            return needComma;
        }
        if (fieldValues.length > 1) {
            if (needComma) {
                pw.print(",");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int j = 0; j < fieldValues.length; ++j) {
                sb.append(KafkaMessage.jsonStringEscape(fieldValues[j])).append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append("]");
            pw.print(KafkaMessage.jsonStringEscape(fieldName) + " : " + sb.toString());
            needComma = true;
        }
        return needComma;
    }

    protected static boolean writeACLs(PrintWriter pw, boolean needComma, String aclType, String[] acl, String[] denyAcl) throws IOException {
        String metadataACLName = "allow_token_" + aclType;
        needComma = acl != null && acl.length > 0 ? KafkaMessage.writeField(pw, needComma, metadataACLName, acl) : KafkaMessage.writeField(pw, needComma, metadataACLName, new String[]{"__nosecurity__"});
        String metadataDenyACLName = "deny_token_" + aclType;
        needComma = denyAcl != null && denyAcl.length > 0 ? KafkaMessage.writeField(pw, needComma, metadataDenyACLName, denyAcl) : KafkaMessage.writeField(pw, needComma, metadataDenyACLName, new String[]{"__nosecurity__"});
        return needComma;
    }

    protected static String jsonStringEscape(String value) {
        StringBuilder sb = new StringBuilder("\"");
        for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            if (x == '\n') {
                sb.append('\\').append('n');
                continue;
            }
            if (x == '\r') {
                sb.append('\\').append('r');
                continue;
            }
            if (x == '\t') {
                sb.append('\\').append('t');
                continue;
            }
            if (x == '\b') {
                sb.append('\\').append('b');
                continue;
            }
            if (x == '\f') {
                sb.append('\\').append('f');
                continue;
            }
            if (x == '\"' || x == '\\' || x == '/') {
                sb.append('\\');
            }
            sb.append(x);
        }
        sb.append("\"");
        return sb.toString();
    }
}

