/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableBase;
import org.apache.manifoldcf.scriptengine.VariableBoolean;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class VariableString
extends VariableBase {
    protected String value;

    public VariableString(String value) {
        this.value = value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableString)) {
            return false;
        }
        return ((VariableString)o).value.equals(this.value);
    }

    @Override
    public boolean hasStringValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean hasScriptValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean hasIntValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean hasDoubleValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean hasURLPathValue() throws ScriptException {
        return true;
    }

    @Override
    public String getURLPathValue() throws ScriptException {
        return URLEncoder.encode((String)this.value).replace("+", "%20");
    }

    @Override
    public String getScriptValue() throws ScriptException {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        int i = 0;
        while (i < this.value.length()) {
            char x;
            if ((x = this.value.charAt(i++)) == '\\' || x == '\"') {
                sb.append('\\');
            }
            sb.append(x);
        }
        sb.append("\"");
        return sb.toString();
    }

    @Override
    public String getStringValue() throws ScriptException {
        return this.value;
    }

    @Override
    public int getIntValue() throws ScriptException {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            throw new ScriptException(e.getMessage(), e);
        }
    }

    @Override
    public double getDoubleValue() throws ScriptException {
        return new Double(this.value);
    }

    @Override
    public VariableReference plus(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '+' operand cannot be null"));
        }
        return new VariableString(this.value + v.getStringValue());
    }

    @Override
    public VariableReference doubleEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '==' operand cannot be null"));
        }
        return new VariableBoolean(this.value.equals(v.getStringValue()));
    }

    @Override
    public VariableReference exclamationEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '!=' operand cannot be null"));
        }
        return new VariableBoolean(!this.value.equals(v.getStringValue()));
    }
}

