/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import java.util.ArrayList;
import java.util.List;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.Token;
import org.apache.manifoldcf.scriptengine.TokenStream;

public class RewindableTokenStream
implements TokenStream {
    protected TokenStream parent;
    protected List<Token> history = new ArrayList<Token>();
    protected int currentIndex = 0;
    protected int committedSize = 0;

    public RewindableTokenStream(TokenStream parent) {
        this.parent = parent;
    }

    @Override
    public Token peek() throws ScriptException {
        if (this.history.size() > this.currentIndex) {
            return this.history.get(this.currentIndex);
        }
        Token rval = this.parent.peek();
        this.history.add(rval);
        return rval;
    }

    @Override
    public void skip() {
        ++this.currentIndex;
        if (this.currentIndex > this.committedSize) {
            this.parent.skip();
            ++this.committedSize;
        }
        if (this.currentIndex > this.committedSize) {
            throw new RuntimeException("Two skips in a row!");
        }
    }

    public void reset() {
        this.currentIndex = 0;
    }
}

