/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class DefineJob {
    public static final String _rcsid = "@(#)$Id: DefineJob.java 988245 2010-08-23 18:39:35Z kwright $";

    private DefineJob() {
    }

    public static void main(String[] args) {
        if (args.length != 13) {
            System.err.println("Usage: DefineJob <description> <connection_name> <type> <start_method> <hopcount_method> <recrawl_interval> <expiration_interval> <reseed_interval> <job_priority> <hop_filters> <filespec_xml>");
            System.err.println("<type> is one of: continuous or specified");
            System.err.println("<start_method> is one of: windowbegin, windowinside, disable");
            System.err.println("<hopcount_method> is one of: accurate, nodelete, neverdelete");
            System.err.println("<recrawl_interval> is the default document recrawl interval in minutes");
            System.err.println("<expiration_interval> is the default document expiration interval in minutes");
            System.err.println("<reseed_interval> is the default document reseed interval in minutes");
            System.err.println("<job_priority> is the job priority (and integer between 0 and 10)");
            System.err.println("<hop_filters> is a comma-separated list of tuples, of the form 'linktype=maxhops'");
            System.err.println("<filespec_xml> is the document specification XML, its form dependent on the connection type");
            System.exit(-1);
        }
        String description = args[0];
        String connectionName = args[1];
        String typeString = args[2];
        String startString = args[3];
        String hopcountString = args[4];
        String recrawlInterval = args[5];
        String expirationInterval = args[6];
        String reseedInterval = args[7];
        String jobPriority = args[8];
        String hopFilters = args[9];
        String filespecXML = args[10];
        try {
            IThreadContext tc = ThreadContextFactory.make();
            ManifoldCF.initializeEnvironment(tc);
            IJobManager jobManager = JobManagerFactory.make(tc);
            IJobDescription desc = jobManager.createJob();
            desc.setDescription(description);
            desc.setConnectionName(connectionName);
            if (typeString.equals("continuous")) {
                desc.setType(0);
            } else if (typeString.equals("specified")) {
                desc.setType(1);
            } else {
                throw new ManifoldCFException("Unknown type: '" + typeString + "'");
            }
            if (startString.equals("windowbegin")) {
                desc.setStartMethod(0);
            } else if (startString.equals("windowinside")) {
                desc.setStartMethod(1);
            } else if (startString.equals("disable")) {
                desc.setStartMethod(2);
            } else {
                throw new ManifoldCFException("Unknown start method: '" + startString + "'");
            }
            if (hopcountString.equals("accurate")) {
                desc.setHopcountMode(0);
            } else if (hopcountString.equals("nodelete")) {
                desc.setHopcountMode(1);
            } else if (hopcountString.equals("neverdelete")) {
                desc.setHopcountMode(2);
            } else {
                throw new ManifoldCFException("Unknown hopcount mode: '" + hopcountString + "'");
            }
            if (recrawlInterval.length() > 0) {
                desc.setInterval(new Long(recrawlInterval));
            }
            if (expirationInterval.length() > 0) {
                desc.setExpiration(new Long(expirationInterval));
            }
            if (reseedInterval.length() > 0) {
                desc.setReseedInterval(new Long(reseedInterval));
            }
            desc.setPriority(Integer.parseInt(jobPriority));
            String[] hopFilterSet = hopFilters.split(",");
            int i = 0;
            while (i < hopFilterSet.length) {
                String[] stuff;
                String hopFilter;
                if ((hopFilter = hopFilterSet[i++]) == null || hopFilter.length() <= 0 || (stuff = hopFilter.trim().split("=")) == null || stuff.length != 2) continue;
                desc.addHopCountFilter(stuff[0], stuff[1].length() > 0 ? new Long(stuff[1]) : null);
            }
            desc.getSpecification().fromXML(filespecXML);
            jobManager.save(desc);
            System.out.print(desc.getID().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-2);
        }
    }
}

