/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.processor.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.docgen.processor.internal.StructuralNodeImpl;
import org.asciidoctor.ast.Column;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.Table;

public final class TableImpl
extends StructuralNodeImpl
implements Table {
    private final List<Row> body = new ArrayList<Row>();

    public TableImpl(ContentNode parent) {
        super(parent);
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        int colCount = this.body.isEmpty() ? 1 : this.body.get(0).getCells().size();
        buffer.append("[cols=\"");
        TableImpl.formatColSpecifier(colCount, buffer);
        buffer.append("\"]\n").append("|===\n");
        this.getBody().forEach(row -> TableImpl.formatRow(row, buffer));
        buffer.append("\n|===\n");
    }

    private static void formatColSpecifier(int colCount, StringBuilder buffer) {
        if (colCount > 0) {
            buffer.append("1");
        }
        for (int i = 1; i < colCount; ++i) {
            buffer.append(",1");
        }
    }

    private static void formatRow(Row row, StringBuilder buffer) {
        buffer.append('\n');
        TableImpl.formatNodeCollection(row.getCells(), "", buffer);
    }

    public List<Row> getBody() {
        return this.body;
    }

    public List<Row> getHeader() {
        throw new UnsupportedOperationException();
    }

    public List<Row> getFooter() {
        throw new UnsupportedOperationException();
    }

    public boolean hasHeaderOption() {
        throw new UnsupportedOperationException();
    }

    public List<Column> getColumns() {
        throw new UnsupportedOperationException();
    }

    public String getFrame() {
        throw new UnsupportedOperationException();
    }

    public void setFrame(String frame) {
        throw new UnsupportedOperationException();
    }

    public String getGrid() {
        throw new UnsupportedOperationException();
    }

    public void setGrid(String grid) {
        throw new UnsupportedOperationException();
    }
}

