/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.io.stax;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class IndentingXMLStreamWriter
implements XMLStreamWriter {
    private XMLStreamWriter out;
    private static final String NEW_LINE = "\n";
    private String newLine = "\n";
    private String indent = "  ";
    private char[] linePrefix = "                        ".toCharArray();
    private int depth;
    private byte[] states = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int ELEMENT_HAS_DATA = 1;
    private static final int ELEMENT_HAS_MARKUP = 2;

    public IndentingXMLStreamWriter(XMLStreamWriter out) {
        this.out = out;
    }

    @Override
    public void close() throws XMLStreamException {
        this.out.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.out.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.out.getNamespaceContext();
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.out.getPrefix(uri);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.out.getProperty(name);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.out.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.out.setNamespaceContext(context);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.out.setPrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.out.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.out.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.out.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.out.writeCData(data);
        this.afterData();
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.out.writeCharacters(text);
        this.afterData();
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.out.writeCharacters(text, start, len);
        this.afterData();
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.beforeMarkup();
        this.out.writeComment(data);
        this.afterMarkup();
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.beforeMarkup();
        this.out.writeDTD(dtd);
        this.afterMarkup();
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.out.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.beforeMarkup();
        this.out.writeEmptyElement(localName);
        this.afterMarkup();
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.beforeMarkup();
        this.out.writeEmptyElement(namespaceURI, localName);
        this.afterMarkup();
    }

    @Override
    public void writeEmptyElement(String prefix, String namespaceURI, String localName) throws XMLStreamException {
        this.beforeMarkup();
        this.out.writeEmptyElement(prefix, namespaceURI, localName);
        this.afterMarkup();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.out.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.beforeEndElement();
        this.out.writeEndElement();
        this.afterEndElement();
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.out.writeEntityRef(name);
        this.afterData();
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.out.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.beforeMarkup();
        this.out.writeProcessingInstruction(target);
        this.afterMarkup();
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.beforeMarkup();
        this.out.writeProcessingInstruction(target, data);
        this.afterMarkup();
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.beforeMarkup();
        this.out.writeStartDocument();
        this.afterMarkup();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.beforeMarkup();
        this.out.writeStartDocument(version);
        this.afterMarkup();
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.beforeMarkup();
        this.out.writeStartDocument(encoding, version);
        this.afterMarkup();
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.beforeStartElement();
        this.out.writeStartElement(localName);
        this.afterStartElement();
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.beforeStartElement();
        this.out.writeStartElement(namespaceURI, localName);
        this.afterStartElement();
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.beforeStartElement();
        this.out.writeStartElement(prefix, localName, namespaceURI);
        this.afterStartElement();
    }

    private void afterData() {
        int n = this.depth;
        this.states[n] = (byte)(this.states[n] | 1);
    }

    private void afterEndElement() {
        if (this.depth > 0) {
            --this.depth;
            if (this.depth <= 0) {
                this.newLine(0);
            }
        }
    }

    private void afterMarkup() {
        int n = this.depth;
        this.states[n] = (byte)(this.states[n] | 2);
    }

    private void afterStartElement() {
        this.afterMarkup();
        ++this.depth;
    }

    private void beforeEndElement() {
        if (this.depth > 0 && this.states[this.depth] == 2) {
            this.newLine(this.depth - 1);
        }
    }

    private void beforeMarkup() {
        byte state = this.states[this.depth];
        if ((state & 1) == 0 && (this.depth > 0 || state != 0)) {
            this.newLine(this.depth);
            if (this.depth > 0 && this.indent.length() > 0) {
                this.afterMarkup();
            }
        }
    }

    private void beforeStartElement() {
        this.beforeMarkup();
        if (this.states.length <= this.depth + 1) {
            byte[] tmp = new byte[this.states.length * 2];
            System.arraycopy(this.states, 0, tmp, 0, this.states.length);
            this.states = tmp;
        }
        this.states[this.depth + 1] = 0;
    }

    public String getLineSeparator() {
        try {
            return System.getProperty("line.separator", NEW_LINE);
        }
        catch (Exception e) {
            return NEW_LINE;
        }
    }

    private void newLine(int depth) {
        try {
            this.out.writeCharacters(this.newLine);
            int prefixLength = depth * this.indent.length();
            while (this.linePrefix.length < prefixLength) {
                char[] tmp = new char[this.linePrefix.length * 2];
                System.arraycopy(this.linePrefix, 0, tmp, 0, this.linePrefix.length);
                System.arraycopy(this.linePrefix, 0, tmp, this.linePrefix.length, this.linePrefix.length);
                this.linePrefix = tmp;
            }
            this.out.writeCharacters(this.linePrefix, 0, prefixLength);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setNewLine(String newLine) {
        this.newLine = newLine;
    }
}

