/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.log4j.xml;

import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

import java.io.ByteArrayInputStream;


/**
 * An {@link EntityResolver} specifically designed to return
 * an empty InputSource for logger.dtd.
 */
public final class UtilLoggingEntityResolver implements EntityResolver {

    /**
     * Create new instance.
     */
    public UtilLoggingEntityResolver() {
        super();
    }


    /**
     * {@inheritDoc}
     */
    public InputSource resolveEntity(final String publicId,
                                     final String systemId) {
        if (systemId.endsWith("logger.dtd")) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        } else {
            return null;
        }
    }
}
