/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.prefs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.chainsaw.prefs.SettingsEvent;

public class LoadSettingsEvent
extends SettingsEvent {
    private final Properties properties;

    LoadSettingsEvent(Object source, Properties properties) {
        super(source);
        this.properties = properties;
    }

    public String getSetting(String key) {
        return this.properties.getProperty(key);
    }

    public boolean asBoolean(String key) {
        return Boolean.valueOf(this.getSetting(key));
    }

    public int asInt(String key) {
        String val = this.getSetting(key);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new RuntimeException("An error occurred retrieving the Integer value of the setting '" + key + "'");
        }
    }

    public Collection getSettingsStartingWith(String string) {
        ArrayList<Object> c = new ArrayList<Object>();
        for (Map.Entry<Object, Object> objectObjectEntry : this.properties.entrySet()) {
            Map.Entry<Object, Object> entry = objectObjectEntry;
            if (!entry.getKey().toString().startsWith(string)) continue;
            c.add(entry.getValue());
        }
        return Collections.unmodifiableCollection(c);
    }
}

