/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.util.List;
import org.apache.directory.mavibot.btree.AbstractResult;
import org.apache.directory.mavibot.btree.InsertResult;
import org.apache.directory.mavibot.btree.Page;

class SplitResult<K, V>
extends AbstractResult<K, V>
implements InsertResult<K, V> {
    protected Page<K, V> leftPage;
    protected Page<K, V> rightPage;
    protected K pivot;

    public SplitResult(K pivot, Page<K, V> leftPage, Page<K, V> rightPage) {
        this.pivot = pivot;
        this.leftPage = leftPage;
        this.rightPage = rightPage;
    }

    public SplitResult(List<Page<K, V>> copiedPages, K pivot, Page<K, V> leftPage, Page<K, V> rightPage) {
        super(copiedPages);
        this.pivot = pivot;
        this.leftPage = leftPage;
        this.rightPage = rightPage;
    }

    public Page<K, V> getLeftPage() {
        return this.leftPage;
    }

    public Page<K, V> getRightPage() {
        return this.rightPage;
    }

    public K getPivot() {
        return this.pivot;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SplitResult, new pivot = ").append(this.pivot);
        sb.append("\n    leftPage = ").append(this.leftPage);
        sb.append("\n    rightPage = ").append(this.rightPage);
        sb.append(super.toString());
        return sb.toString();
    }
}

