/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiMapEntry;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Arguments to perform installation on one or more hosts")
public class ApiHostInstallArguments {
    @SerializedName(value="hostNames")
    private List<String> hostNames = null;
    @SerializedName(value="sshPort")
    private BigDecimal sshPort = null;
    @SerializedName(value="userName")
    private String userName = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="privateKey")
    private String privateKey = null;
    @SerializedName(value="passphrase")
    private String passphrase = null;
    @SerializedName(value="parallelInstallCount")
    private BigDecimal parallelInstallCount = null;
    @SerializedName(value="cmRepoUrl")
    private String cmRepoUrl = null;
    @SerializedName(value="gpgKeyCustomUrl")
    private String gpgKeyCustomUrl = null;
    @SerializedName(value="javaInstallStrategy")
    private String javaInstallStrategy = null;
    @SerializedName(value="unlimitedJCE")
    private Boolean unlimitedJCE = null;
    @SerializedName(value="gpgKeyOverrideBundle")
    private String gpgKeyOverrideBundle = null;
    @SerializedName(value="agentReportedHostnames")
    private List<ApiMapEntry> agentReportedHostnames = null;
    @SerializedName(value="subjectAltNames")
    private List<String> subjectAltNames = null;

    public ApiHostInstallArguments hostNames(List<String> hostNames) {
        this.hostNames = hostNames;
        return this;
    }

    public ApiHostInstallArguments addHostNamesItem(String hostNamesItem) {
        if (this.hostNames == null) {
            this.hostNames = new ArrayList<String>();
        }
        this.hostNames.add(hostNamesItem);
        return this;
    }

    @Schema(description="List of hosts to configure for use with Cloudera Manager. A host may be specified by a hostname (FQDN) or an IP address.")
    public List<String> getHostNames() {
        return this.hostNames;
    }

    public void setHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
    }

    public ApiHostInstallArguments sshPort(BigDecimal sshPort) {
        this.sshPort = sshPort;
        return this;
    }

    @Schema(description="SSH port. If unset, defaults to 22.")
    public BigDecimal getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(BigDecimal sshPort) {
        this.sshPort = sshPort;
    }

    public ApiHostInstallArguments userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(description="The username used to authenticate with the hosts. Root access to your hosts is required to install Cloudera packages. The installer will connect to your hosts via SSH and log in either directly as root or as another user with password-less sudo privileges to become root.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ApiHostInstallArguments password(String password) {
        this.password = password;
        return this;
    }

    @Schema(description="The password used to authenticate with the hosts. Specify either this or a private key. For password-less login, use an empty string as password.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ApiHostInstallArguments privateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @Schema(description="The private key to authenticate with the hosts. Specify either this or a password. <br> The private key, if specified, needs to be a standard PEM-encoded key as a single string, with all line breaks replaced with the line-feed control character '\\n'. <br> A value will typically look like the following string: <br> -----BEGIN RSA PRIVATE KEY-----\\n[base-64 encoded key]\\n-----END RSA PRIVATE KEY----- <br>")
    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public ApiHostInstallArguments passphrase(String passphrase) {
        this.passphrase = passphrase;
        return this;
    }

    @Schema(description="The passphrase associated with the private key used to authenticate with the hosts (optional).")
    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public ApiHostInstallArguments parallelInstallCount(BigDecimal parallelInstallCount) {
        this.parallelInstallCount = parallelInstallCount;
        return this;
    }

    @Schema(description="Number of simultaneous installations. Defaults to 10. Running a large number of installations at once can consume large amounts of network bandwidth and other system resources.")
    public BigDecimal getParallelInstallCount() {
        return this.parallelInstallCount;
    }

    public void setParallelInstallCount(BigDecimal parallelInstallCount) {
        this.parallelInstallCount = parallelInstallCount;
    }

    public ApiHostInstallArguments cmRepoUrl(String cmRepoUrl) {
        this.cmRepoUrl = cmRepoUrl;
        return this;
    }

    @Schema(description="The Cloudera Manager repository URL to use (optional). Example for SLES, Redhat or Debian based distributions: https://archive.cloudera.com/cm6/6.0.0")
    public String getCmRepoUrl() {
        return this.cmRepoUrl;
    }

    public void setCmRepoUrl(String cmRepoUrl) {
        this.cmRepoUrl = cmRepoUrl;
    }

    public ApiHostInstallArguments gpgKeyCustomUrl(String gpgKeyCustomUrl) {
        this.gpgKeyCustomUrl = gpgKeyCustomUrl;
        return this;
    }

    @Schema(description="The Cloudera Manager public GPG key (optional). Example for SLES, Redhat or other RPM based distributions: https://archive.cloudera.com/cm5/redhat/5/x86_64/cm/RPM-GPG-KEY-cloudera Example for Ubuntu or other Debian based distributions: https://archive.cloudera.com/cm5/ubuntu/lucid/amd64/cm/archive.key")
    public String getGpgKeyCustomUrl() {
        return this.gpgKeyCustomUrl;
    }

    public void setGpgKeyCustomUrl(String gpgKeyCustomUrl) {
        this.gpgKeyCustomUrl = gpgKeyCustomUrl;
    }

    public ApiHostInstallArguments javaInstallStrategy(String javaInstallStrategy) {
        this.javaInstallStrategy = javaInstallStrategy;
        return this;
    }

    @Schema(description="Added in v8: Strategy to use for JDK installation. Valid values are <br> 1. AUTO: Cloudera Manager will install the JDK versions that are required when the \"AUTO\" option is selected. This package will be downloaded from Cloudera repository. This operation may overwrite any of the existing JDK installations. <br> 2. NONE(default): Cloudera Manager will not install any JDK when \"NONE\" option is selected. It should be used if an existing JDK installation can be used. NOTE: Selecting the \"NONE\" option makes it the customer's responsibility to ensure that the unlimited strength JCE policy files are installed and enabled on each host, as appropriate for the version of Java in use. <br> 3. OS_PROVIDED_JDK: Option added in v40, Cloudera Manager will install OpenJDK packages provided by the [non-cloudera] Operating System repositories configured on each host. This operation may overwrite any of the existing JDK installations.")
    public String getJavaInstallStrategy() {
        return this.javaInstallStrategy;
    }

    public void setJavaInstallStrategy(String javaInstallStrategy) {
        this.javaInstallStrategy = javaInstallStrategy;
    }

    public ApiHostInstallArguments unlimitedJCE(Boolean unlimitedJCE) {
        this.unlimitedJCE = unlimitedJCE;
        return this;
    }

    @Schema(description="Added in v8: Flag for unlimited strength JCE policy files installation If unset, defaults to false <br> Deprecated in CM 7.0.2: Flag for unlimited strength JCE policy files installation will be set to False. NOTE: With OpenJDK11 (and OpenJDK8 u232), JCE is installed and enabled by default.")
    public Boolean isUnlimitedJCE() {
        return this.unlimitedJCE;
    }

    public void setUnlimitedJCE(Boolean unlimitedJCE) {
        this.unlimitedJCE = unlimitedJCE;
    }

    public ApiHostInstallArguments gpgKeyOverrideBundle(String gpgKeyOverrideBundle) {
        this.gpgKeyOverrideBundle = gpgKeyOverrideBundle;
        return this;
    }

    @Schema(description="The Cloudera Manager public GPG key (optional). This points to the actual bundle contents and not a URL.")
    public String getGpgKeyOverrideBundle() {
        return this.gpgKeyOverrideBundle;
    }

    public void setGpgKeyOverrideBundle(String gpgKeyOverrideBundle) {
        this.gpgKeyOverrideBundle = gpgKeyOverrideBundle;
    }

    public ApiHostInstallArguments agentReportedHostnames(List<ApiMapEntry> agentReportedHostnames) {
        this.agentReportedHostnames = agentReportedHostnames;
        return this;
    }

    public ApiHostInstallArguments addAgentReportedHostnamesItem(ApiMapEntry agentReportedHostnamesItem) {
        if (this.agentReportedHostnames == null) {
            this.agentReportedHostnames = new ArrayList<ApiMapEntry>();
        }
        this.agentReportedHostnames.add(agentReportedHostnamesItem);
        return this;
    }

    @Schema(description="Optional. A map from hostname to reported_hostname value to be set in the agent configuration file.")
    public List<ApiMapEntry> getAgentReportedHostnames() {
        return this.agentReportedHostnames;
    }

    public void setAgentReportedHostnames(List<ApiMapEntry> agentReportedHostnames) {
        this.agentReportedHostnames = agentReportedHostnames;
    }

    public ApiHostInstallArguments subjectAltNames(List<String> subjectAltNames) {
        this.subjectAltNames = subjectAltNames;
        return this;
    }

    public ApiHostInstallArguments addSubjectAltNamesItem(String subjectAltNamesItem) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        this.subjectAltNames.add(subjectAltNamesItem);
        return this;
    }

    @Schema(description="")
    public List<String> getSubjectAltNames() {
        return this.subjectAltNames;
    }

    public void setSubjectAltNames(List<String> subjectAltNames) {
        this.subjectAltNames = subjectAltNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHostInstallArguments apiHostInstallArguments = (ApiHostInstallArguments)o;
        return Objects.equals(this.hostNames, apiHostInstallArguments.hostNames) && Objects.equals(this.sshPort, apiHostInstallArguments.sshPort) && Objects.equals(this.userName, apiHostInstallArguments.userName) && Objects.equals(this.password, apiHostInstallArguments.password) && Objects.equals(this.privateKey, apiHostInstallArguments.privateKey) && Objects.equals(this.passphrase, apiHostInstallArguments.passphrase) && Objects.equals(this.parallelInstallCount, apiHostInstallArguments.parallelInstallCount) && Objects.equals(this.cmRepoUrl, apiHostInstallArguments.cmRepoUrl) && Objects.equals(this.gpgKeyCustomUrl, apiHostInstallArguments.gpgKeyCustomUrl) && Objects.equals(this.javaInstallStrategy, apiHostInstallArguments.javaInstallStrategy) && Objects.equals(this.unlimitedJCE, apiHostInstallArguments.unlimitedJCE) && Objects.equals(this.gpgKeyOverrideBundle, apiHostInstallArguments.gpgKeyOverrideBundle) && Objects.equals(this.agentReportedHostnames, apiHostInstallArguments.agentReportedHostnames) && Objects.equals(this.subjectAltNames, apiHostInstallArguments.subjectAltNames);
    }

    public int hashCode() {
        return Objects.hash(this.hostNames, this.sshPort, this.userName, this.password, this.privateKey, this.passphrase, this.parallelInstallCount, this.cmRepoUrl, this.gpgKeyCustomUrl, this.javaInstallStrategy, this.unlimitedJCE, this.gpgKeyOverrideBundle, this.agentReportedHostnames, this.subjectAltNames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHostInstallArguments {\n");
        sb.append("    hostNames: ").append(this.toIndentedString(this.hostNames)).append("\n");
        sb.append("    sshPort: ").append(this.toIndentedString(this.sshPort)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    privateKey: ").append(this.toIndentedString(this.privateKey)).append("\n");
        sb.append("    passphrase: ").append(this.toIndentedString(this.passphrase)).append("\n");
        sb.append("    parallelInstallCount: ").append(this.toIndentedString(this.parallelInstallCount)).append("\n");
        sb.append("    cmRepoUrl: ").append(this.toIndentedString(this.cmRepoUrl)).append("\n");
        sb.append("    gpgKeyCustomUrl: ").append(this.toIndentedString(this.gpgKeyCustomUrl)).append("\n");
        sb.append("    javaInstallStrategy: ").append(this.toIndentedString(this.javaInstallStrategy)).append("\n");
        sb.append("    unlimitedJCE: ").append(this.toIndentedString(this.unlimitedJCE)).append("\n");
        sb.append("    gpgKeyOverrideBundle: ").append(this.toIndentedString(this.gpgKeyOverrideBundle)).append("\n");
        sb.append("    agentReportedHostnames: ").append(this.toIndentedString(this.agentReportedHostnames)).append("\n");
        sb.append("    subjectAltNames: ").append(this.toIndentedString(this.subjectAltNames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

