/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl.xml;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterApplyDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterBufferDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterDetectDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterGroupDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterPathDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterScopeDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFlowDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFunctionDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRuleDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteStepDescriptor;
import org.apache.knox.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.knox.gateway.filter.rewrite.impl.xml.XmlRewriteRulesTags;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteRulesExporter;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.util.XmlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlUrlRewriteRulesExporter
implements UrlRewriteRulesExporter,
XmlRewriteRulesTags {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);

    @Override
    public String getFormat() {
        return "xml";
    }

    @Override
    public void store(UrlRewriteRulesDescriptor descriptor, Writer writer) throws IOException {
        try {
            Document document = XmlUtils.createDocument();
            Element root = document.createElement("rules");
            document.appendChild(root);
            if (!descriptor.getFunctions().isEmpty()) {
                Element functionsElement = document.createElement("functions");
                root.appendChild(functionsElement);
                for (UrlRewriteFunctionDescriptor function : descriptor.getFunctions()) {
                    Element functionElement = this.createElement(document, function.name(), function);
                    functionsElement.appendChild(functionElement);
                }
            }
            if (!descriptor.getRules().isEmpty()) {
                for (UrlRewriteRuleDescriptor rule : descriptor.getRules()) {
                    Element ruleElement = this.createRule(document, rule);
                    root.appendChild(ruleElement);
                }
            }
            if (!descriptor.getFilters().isEmpty()) {
                for (UrlRewriteFilterDescriptor filter : descriptor.getFilters()) {
                    Element filterElement = this.createFilter(document, filter);
                    root.appendChild(filterElement);
                }
            }
            XmlUtils.writeXml((Document)document, (Writer)writer);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            LOG.failedToWriteRulesDescriptor(e);
        }
        catch (NoSuchMethodException e) {
            LOG.failedToWriteRulesDescriptor(e);
        }
        catch (IntrospectionException e) {
            LOG.failedToWriteRulesDescriptor(e);
        }
        catch (IllegalAccessException e) {
            LOG.failedToWriteRulesDescriptor(e);
        }
    }

    private Element createFilter(Document document, UrlRewriteFilterDescriptor parent) throws IntrospectionException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Element parentElement = this.createElement(document, "filter", parent);
        for (UrlRewriteFilterContentDescriptor child : parent.getContents()) {
            Element childElement = this.createFilterContent(document, child);
            parentElement.appendChild(childElement);
        }
        return parentElement;
    }

    private Element createFilterContent(Document document, UrlRewriteFilterContentDescriptor parent) throws IntrospectionException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Element parentElement = this.createElement(document, "content", parent);
        for (UrlRewriteFilterPathDescriptor child : parent.getSelectors()) {
            Element childElement = this.createFilterSelector(document, child);
            parentElement.appendChild(childElement);
        }
        return parentElement;
    }

    private Element createFilterSelector(Document document, UrlRewriteFilterPathDescriptor parent) throws IntrospectionException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Element parentElement = this.createElement(document, XmlUrlRewriteRulesExporter.toTagName(parent), parent);
        if (parent instanceof UrlRewriteFilterGroupDescriptor) {
            for (UrlRewriteFilterPathDescriptor child : ((UrlRewriteFilterGroupDescriptor)parent).getSelectors()) {
                Element childElement = this.createFilterSelector(document, child);
                parentElement.appendChild(childElement);
            }
        }
        return parentElement;
    }

    private Element createRule(Document document, UrlRewriteRuleDescriptor rule) throws IntrospectionException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Element ruleElement = this.createElement(document, "rule", rule);
        for (UrlRewriteStepDescriptor step : rule.steps()) {
            Element childElement = this.createStep(document, step);
            ruleElement.appendChild(childElement);
        }
        return ruleElement;
    }

    private Element createStep(Document document, UrlRewriteStepDescriptor step) throws IntrospectionException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Element parentElement = this.createElement(document, step.type(), step);
        if (step instanceof UrlRewriteFlowDescriptor) {
            UrlRewriteFlowDescriptor flow = (UrlRewriteFlowDescriptor)step;
            Iterator<UrlRewriteStepDescriptor> iterator = flow.steps().iterator();
            while (iterator.hasNext()) {
                UrlRewriteStepDescriptor child;
                UrlRewriteStepDescriptor childStep = child = iterator.next();
                Element childElement = this.createStep(document, childStep);
                parentElement.appendChild(childElement);
            }
        }
        return parentElement;
    }

    private Element createElement(Document document, String name, Object bean) throws IntrospectionException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Element element = document.createElement(name);
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass(), Object.class);
        for (PropertyDescriptor propInfo : beanInfo.getPropertyDescriptors()) {
            String propValue;
            String propName = propInfo.getName();
            if (propInfo.getReadMethod() == null || !String.class.isAssignableFrom(propInfo.getPropertyType()) || (propValue = BeanUtils.getProperty((Object)bean, (String)propName)) == null || propValue.isEmpty()) continue;
            Attr attr = document.createAttribute(propName);
            attr.setValue(propValue);
            element.setAttributeNode(attr);
        }
        return element;
    }

    private static String toTagName(UrlRewriteFilterPathDescriptor descriptor) {
        if (descriptor instanceof UrlRewriteFilterApplyDescriptor) {
            return "apply";
        }
        if (descriptor instanceof UrlRewriteFilterDetectDescriptor) {
            return "detect";
        }
        if (descriptor instanceof UrlRewriteFilterBufferDescriptor) {
            return "buffer";
        }
        if (descriptor instanceof UrlRewriteFilterScopeDescriptor) {
            return "scope";
        }
        throw new IllegalArgumentException();
    }
}

