/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.dispatch;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.knox.gateway.ha.dispatch.DefaultHaDispatch;

public class AtlasHaDispatch
extends DefaultHaDispatch {
    private static Set<String> REQUEST_EXCLUDE_HEADERS = new HashSet<String>();

    public AtlasHaDispatch() {
        this.setServiceRole("ATLAS");
    }

    @Override
    public void init() {
        super.init();
    }

    public Set<String> getOutboundResponseExcludeHeaders() {
        return Collections.emptySet();
    }

    public Set<String> getOutboundRequestExcludeHeaders() {
        return REQUEST_EXCLUDE_HEADERS;
    }

    @Override
    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = null;
        try {
            inboundResponse = this.executeOutboundRequest(outboundRequest);
            int sc = inboundResponse.getStatusLine().getStatusCode();
            if (!(sc != 302 && sc != 307 || this.isLoginRedirect(inboundResponse.getFirstHeader("Location")))) {
                inboundResponse.removeHeaders("Location");
                this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, new Exception("Atlas HA redirection"));
            }
            this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
        }
        catch (IOException e) {
            LOG.errorConnectingToServer(outboundRequest.getURI().toString(), e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
    }

    private boolean isLoginRedirect(Header locationHeader) {
        boolean result = false;
        if (locationHeader != null) {
            String value = locationHeader.getValue();
            result = value.endsWith("login.jsp") || value.contains("originalUrl");
        }
        return result;
    }

    static {
        REQUEST_EXCLUDE_HEADERS.add("Content-Length");
    }
}

