/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.common.filter;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.knox.gateway.IdentityAsserterMessages;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.filter.security.AbstractIdentityAssertionBase;
import org.apache.knox.gateway.i18n.GatewaySpiResources;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.security.GroupPrincipal;
import org.apache.knox.gateway.security.ImpersonatedPrincipal;
import org.apache.knox.gateway.security.PrimaryPrincipal;

public abstract class AbstractIdentityAssertionFilter
extends AbstractIdentityAssertionBase
implements Filter {
    private IdentityAsserterMessages LOG = (IdentityAsserterMessages)MessagesFactory.get(IdentityAsserterMessages.class);
    private static final GatewaySpiResources RES = (GatewaySpiResources)ResourcesFactory.get(GatewaySpiResources.class);
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");

    public abstract String[] mapGroupPrincipals(String var1, Subject var2);

    public abstract String mapUserPrincipal(String var1);

    protected void continueChainAsPrincipal(HttpServletRequestWrapper request, ServletResponse response, FilterChain chain, String mappedPrincipalName, String[] groups) throws IOException, ServletException {
        Subject subject = null;
        ImpersonatedPrincipal impersonationPrincipal = null;
        PrimaryPrincipal primaryPrincipal = null;
        boolean impersonationNeeded = false;
        boolean groupsMapped = false;
        Subject currentSubject = Subject.getSubject(AccessController.getContext());
        if (currentSubject == null) {
            this.LOG.subjectNotAvailable();
            throw new IllegalStateException("Required Subject Missing");
        }
        Set<GroupPrincipal> currentGroups = currentSubject.getPrincipals(GroupPrincipal.class);
        primaryPrincipal = (PrimaryPrincipal)currentSubject.getPrincipals(PrimaryPrincipal.class).toArray()[0];
        if (primaryPrincipal != null) {
            if (!primaryPrincipal.getName().equals(mappedPrincipalName)) {
                impersonationNeeded = true;
                auditService.getContext().setProxyUsername(mappedPrincipalName);
                auditor.audit("identity-mapping", primaryPrincipal.getName(), "principal", "success", RES.effectiveUser(mappedPrincipalName));
            }
        } else {
            primaryPrincipal = new PrimaryPrincipal(request.getUserPrincipal().getName());
        }
        boolean bl = groupsMapped = groups != null || !currentGroups.isEmpty();
        if (impersonationNeeded || groupsMapped) {
            subject = new Subject();
            Set<Principal> principals = subject.getPrincipals();
            principals.add((Principal)primaryPrincipal);
            for (GroupPrincipal obj : currentGroups) {
                principals.add((Principal)obj);
            }
            if (impersonationNeeded) {
                impersonationPrincipal = new ImpersonatedPrincipal(mappedPrincipalName);
                subject.getPrincipals().add((Principal)impersonationPrincipal);
            }
            if (groupsMapped) {
                this.addMappedGroupsToSubject(mappedPrincipalName, groups, subject);
            }
            this.doAs((ServletRequest)request, response, chain, subject);
        } else {
            this.doFilterInternal((ServletRequest)request, response, chain);
        }
    }

    private void doAs(final ServletRequest request, final ServletResponse response, final FilterChain chain, Subject subject) throws IOException, ServletException {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    AbstractIdentityAssertionFilter.this.doFilterInternal(request, response, chain);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }

    private void addMappedGroupsToSubject(String mappedPrincipalName, String[] groups, Subject subject) {
        if (groups != null) {
            auditor.audit("identity-mapping", mappedPrincipalName, "principal", "success", RES.groupsList(Arrays.toString(groups)));
            for (int i = 0; i < groups.length; ++i) {
                subject.getPrincipals().add((Principal)new GroupPrincipal(groups[i]));
            }
        }
    }

    private void doFilterInternal(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
    }
}

