/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.knox.gateway.filter.CompositeEnumeration;
import org.apache.knox.gateway.filter.GatewayRequestWrapper;

public class XForwardedHeaderRequestWrapper
extends GatewayRequestWrapper {
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String X_FORWARDED_FOR_LOWER = "X-Forwarded-For".toLowerCase(Locale.ROOT);
    private static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private static final String X_FORWARDED_PROTO_LOWER = "X-Forwarded-Proto".toLowerCase(Locale.ROOT);
    private static final String X_FORWARDED_PORT = "X-Forwarded-Port";
    private static final String X_FORWARDED_PORT_LOWER = "X-Forwarded-Port".toLowerCase(Locale.ROOT);
    private static final String X_FORWARDED_HOST = "X-Forwarded-Host";
    private static final String X_FORWARDED_HOST_LOWER = "X-Forwarded-Host".toLowerCase(Locale.ROOT);
    private static final String X_FORWARDED_SERVER = "X-Forwarded-Server";
    private static final String X_FORWARDED_SERVER_LOWER = "X-Forwarded-Server".toLowerCase(Locale.ROOT);
    private static final String X_FORWARDED_CONTEXT = "X-Forwarded-Context";
    private static final String X_FORWARDED_CONTEXT_LOWER = "X-Forwarded-Context".toLowerCase(Locale.ROOT);
    private static final ArrayList<String> headerNames = new ArrayList();
    Hashtable<String, String> proxyHeaders = new Hashtable();

    public XForwardedHeaderRequestWrapper(HttpServletRequest request) {
        super(request);
        this.setHeader(X_FORWARDED_FOR_LOWER, XForwardedHeaderRequestWrapper.getForwardedFor(request));
        this.setHeader(X_FORWARDED_PROTO_LOWER, XForwardedHeaderRequestWrapper.getForwardedProto(request));
        this.setHeader(X_FORWARDED_PORT_LOWER, XForwardedHeaderRequestWrapper.getForwardedPort(request));
        this.setHeader(X_FORWARDED_HOST_LOWER, XForwardedHeaderRequestWrapper.getForwardedHost(request));
        this.setHeader(X_FORWARDED_SERVER_LOWER, XForwardedHeaderRequestWrapper.getForwardedServer(request));
        this.setHeader(X_FORWARDED_CONTEXT_LOWER, XForwardedHeaderRequestWrapper.getForwardedContext(request));
    }

    public Enumeration<String> getHeaderNames() {
        return new CompositeEnumeration<String>(Collections.enumeration(headerNames), super.getHeaderNames());
    }

    public Enumeration<String> getHeaders(String name) {
        String value = this.proxyHeaders.get(name = name.toLowerCase(Locale.ROOT));
        Enumeration<String> values = value != null ? Collections.enumeration(Arrays.asList(value)) : super.getHeaders(name);
        return values;
    }

    public String getHeader(String name) {
        String value = this.proxyHeaders.get(name = name.toLowerCase(Locale.ROOT));
        if (value == null) {
            value = super.getHeader(name);
        }
        return value;
    }

    private void setHeader(String name, String value) {
        if (name != null && value != null) {
            this.proxyHeaders.put(name, value);
        }
    }

    private static String getForwardedFor(HttpServletRequest request) {
        String curr = request.getHeader(X_FORWARDED_FOR);
        String addr = request.getRemoteAddr();
        String value = curr == null ? addr : curr + "," + addr;
        return value;
    }

    private static String getForwardedProto(HttpServletRequest request) {
        String value = request.getHeader(X_FORWARDED_PROTO);
        if (value == null) {
            value = request.isSecure() ? "https" : "http";
        }
        return value;
    }

    private static String getForwardedPort(HttpServletRequest request) {
        String value = request.getHeader(X_FORWARDED_PORT);
        if (value == null) {
            String forwardedHost = XForwardedHeaderRequestWrapper.getForwardedHost(request);
            int separator = forwardedHost.indexOf(":");
            value = separator > 0 ? forwardedHost.substring(separator + 1, forwardedHost.length()) : (request.isSecure() ? "443" : "80");
        }
        return value;
    }

    private static String getForwardedHost(HttpServletRequest request) {
        String value = request.getHeader(X_FORWARDED_HOST);
        if (value == null) {
            value = request.getHeader("Host");
        }
        return value;
    }

    private static String getForwardedServer(HttpServletRequest request) {
        return request.getServerName();
    }

    private static String getForwardedContext(HttpServletRequest request) {
        String remote = request.getHeader(X_FORWARDED_CONTEXT);
        String local = request.getContextPath();
        return (remote == null ? "" : remote) + (local == null ? "" : local);
    }

    static {
        headerNames.add(X_FORWARDED_FOR);
        headerNames.add(X_FORWARDED_PROTO);
        headerNames.add(X_FORWARDED_PORT);
        headerNames.add(X_FORWARDED_HOST);
        headerNames.add(X_FORWARDED_SERVER);
        headerNames.add(X_FORWARDED_CONTEXT);
    }
}

