/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxsso;

import java.net.MalformedURLException;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.knoxsso.KnoxSSOutMessages;
import org.apache.knox.gateway.util.Urls;

@Path(value="/api/v1/webssout")
public class WebSSOutResource {
    private static final String JWT_COOKIE_NAME = "hadoop-jwt";
    static final String RESOURCE_PATH = "/api/v1/webssout";
    static final String KNOXSSO_RESOURCE_PATH = "/api/v1/websso";
    private static KnoxSSOutMessages log = (KnoxSSOutMessages)MessagesFactory.get(KnoxSSOutMessages.class);
    private String domainSuffix = null;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;
    @Context
    ServletContext context;

    @PostConstruct
    public void init() {
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response doGet() {
        boolean rc = this.removeAuthenticationToken(this.response);
        if (rc) {
            return Response.ok().entity((Object)"{ \"loggedOut\" : true }").build();
        }
        return Response.ok().entity((Object)"{ \"loggedOut\" : false }").build();
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    public Response doPost() {
        boolean rc = this.removeAuthenticationToken(this.response);
        if (rc) {
            return Response.ok().entity((Object)"{ \"loggedOut\" : true }").build();
        }
        return Response.ok().entity((Object)"{ \"loggedOut\" : false }").build();
    }

    public void setDomainSuffix(String domainSuffix) {
        this.domainSuffix = domainSuffix;
    }

    private boolean removeAuthenticationToken(HttpServletResponse response) {
        boolean rc = true;
        Cookie c = new Cookie(JWT_COOKIE_NAME, null);
        c.setMaxAge(0);
        c.setPath("/");
        try {
            c.setDomain(Urls.getDomainName((String)this.request.getRequestURL().toString(), (String)this.domainSuffix));
        }
        catch (MalformedURLException e) {
            log.problemWithCookieDomainUsingDefault();
            rc = false;
        }
        response.addCookie(c);
        return rc;
    }
}

