/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariComponent;
import org.apache.knox.gateway.topology.discovery.ambari.ServiceURLCreator;

public abstract class SparkCommonServiceURLCreator
implements ServiceURLCreator {
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private static final String URL_TEMPLATE = "%s://%s:%s";
    protected AmbariCluster cluster = null;
    String primaryComponentName = null;
    String secondaryComponentName = null;
    String portConfigProperty = null;

    @Override
    public void init(AmbariCluster cluster) {
        this.cluster = cluster;
    }

    boolean isSSL(AmbariComponent comp) {
        return false;
    }

    String getPort(AmbariComponent comp) {
        return comp.getConfigProperty(this.portConfigProperty);
    }

    @Override
    public List<String> create(String service, Map<String, String> serviceParams) {
        ArrayList<String> urls = new ArrayList<String>();
        if (this.getTargetService().equalsIgnoreCase(service)) {
            AmbariComponent comp = this.cluster.getComponent(this.primaryComponentName);
            if (comp == null) {
                comp = this.cluster.getComponent(this.secondaryComponentName);
            }
            if (comp != null) {
                String port = this.getPort(comp);
                List<String> hostNames = comp.getHostNames();
                for (String host : hostNames) {
                    urls.add(String.format(Locale.ROOT, URL_TEMPLATE, this.isSSL(comp) ? SCHEME_HTTPS : SCHEME_HTTP, host, port));
                }
            }
        }
        return urls;
    }
}

