/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.ambari.ServiceURLCreator;

public abstract class ResourceManagerURLCreatorBase
implements ServiceURLCreator {
    static final String CONFIG_SERVICE = "YARN";
    static final String CONFIG_TYPE = "yarn-site";
    static final String WEBAPP_ADDRESS_HTTP = "yarn.resourcemanager.webapp.address";
    static final String WEBAPP_ADDRESS_HTTPS = "yarn.resourcemanager.webapp.https.address";
    static final String SCHEME_HTTP = "http";
    static final String SCHEME_HTTPS = "https";
    protected AmbariServiceDiscoveryMessages log = (AmbariServiceDiscoveryMessages)MessagesFactory.get(AmbariServiceDiscoveryMessages.class);
    private AmbariCluster cluster = null;

    @Override
    public void init(AmbariCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public List<String> create(String service, Map<String, String> serviceParams) {
        AmbariCluster.ServiceConfiguration sc;
        ArrayList<String> urls = new ArrayList<String>();
        if (this.getTargetService().equals(service) && (sc = this.cluster.getServiceConfiguration(CONFIG_SERVICE, CONFIG_TYPE)) != null) {
            String rmSet;
            Map<String, String> configProps = sc.getProperties();
            String httpPolicy = this.getHttpPolicy(configProps);
            boolean isHAEnabled = Boolean.parseBoolean(configProps.get("yarn.resourcemanager.ha.enabled"));
            if (isHAEnabled && (rmSet = configProps.get("yarn.resourcemanager.ha.rm-ids")) != null) {
                String[] rmIds;
                for (String rmId : rmIds = rmSet.split(",")) {
                    String address = configProps.get(this.getWebAppAddressPropertyName(httpPolicy) + "." + rmId.trim());
                    if (address == null || address.isEmpty()) continue;
                    urls.add(this.createURL(address));
                }
            }
            if (urls.isEmpty()) {
                urls.add(this.createURL(configProps.get(this.getWebAppAddressPropertyName(httpPolicy))));
            }
        }
        return urls;
    }

    protected abstract String createURL(String var1);

    String getURLScheme() {
        return this.isHttps(this.getHttpPolicy()) ? SCHEME_HTTPS : SCHEME_HTTP;
    }

    private String getHttpPolicy() {
        String httpPolicy = null;
        AmbariCluster.ServiceConfiguration sc = this.cluster.getServiceConfiguration(CONFIG_SERVICE, CONFIG_TYPE);
        if (sc != null) {
            httpPolicy = this.getHttpPolicy(sc.getProperties());
        }
        return httpPolicy;
    }

    private String getHttpPolicy(Map<String, String> configProps) {
        return configProps.get("yarn.http.policy");
    }

    private boolean isHttps(String httpPolicy) {
        return "HTTPS_ONLY".equalsIgnoreCase(httpPolicy);
    }

    private String getWebAppAddressPropertyName(String httpPolicy) {
        return this.isHttps(httpPolicy) ? WEBAPP_ADDRESS_HTTPS : WEBAPP_ADDRESS_HTTP;
    }
}

